DESCRIPTION = "efenniht illume theme - Efenniht was devised to be clean \
and neutral. Its name (which means equinox) comes from the chromatic duality \
that was decided at the very beginning, with a dark theme (black and orange) \
and a bright one (white and blue) to be developed so that more people feel \
comfortable using it. Efenniht uses few animations, discrete contrasts between \
shades of gray and fine lines (colored) that outline the selected elements."
SECTION = "e/utils"
HOMEPAGE = "http://trac.enlightenment.org/e/wiki/Themes#Efenniht"
DEPENDS = "edje-native"
RDEPENDS_${PN} = "e-wm"
RSUGGESTS_${PN} = "elementary-theme-efenniht"
LICENSE = "MIT BSD"
LIC_FILES_CHKSUM = "file://${WORKDIR}/LICENSE;md5=f523ab5986cc79b52a90d2ac3d5454a2"

SRCREV = "${EFL_SRCREV}"
PV = "0.0+svnr${SRCPV}"

inherit e-base allarch

SRCNAME = "efenniht"
SRC_URI = "${E_SVN}/trunk/THEMES;module=${SRCNAME};protocol=http \
           file://LICENSE \
"
S = "${WORKDIR}/${SRCNAME}"

do_compile() {
    ${STAGING_BINDIR_NATIVE}/edje_cc -id ${S}/images ${S}/efenniht.edc -o ${S}/efenniht.edj
}

do_install() {
    install -d ${D}${datadir}/enlightenment/data/themes/
    install -m 0644 ${S}/efenniht.edj ${D}${datadir}/enlightenment/data/themes/
}

FILES_${PN} = "${datadir}/enlightenment/data/themes/"
