#
# This is for perl modules that use the old Makefile.PL build system
#
inherit cpan-base perlnative

EXTRA_CPANFLAGS ?= ""
EXTRA_PERLFLAGS ?= ""

# Env var which tells perl if it should use host (no) or target (yes) settings
export PERLCONFIGTARGET = "${@is_target(d)}"

# Env var which tells perl where the perl include files are
export PERL_INC = "${STAGING_LIBDIR}${PERL_OWN_DIR}/perl/${@get_perl_version(d)}/CORE"
export PERL_LIB = "${STAGING_LIBDIR}${PERL_OWN_DIR}/perl/${@get_perl_version(d)}"
export PERL_ARCHLIB = "${STAGING_LIBDIR}${PERL_OWN_DIR}/perl/${@get_perl_version(d)}"
export PERLHOSTLIB = "${STAGING_LIBDIR_NATIVE}/perl-native/perl/${@get_perl_version(d)}/"

cpan_do_configure () {
	export PERL5LIB="${PERL_ARCHLIB}"
	yes '' | perl ${EXTRA_PERLFLAGS} Makefile.PL ${EXTRA_CPANFLAGS}

	# Makefile.PLs can exit with success without generating a
	# Makefile, e.g. in cases of missing configure time
	# dependencies. This is considered a best practice by
	# cpantesters.org. See:
	#  * http://wiki.cpantesters.org/wiki/CPANAuthorNotes
	#  * http://www.nntp.perl.org/group/perl.qa/2008/08/msg11236.html
	[ -e Makefile ] || bbfatal "No Makefile was generated by Makefile.PL"

	if [ "${BUILD_SYS}" != "${HOST_SYS}" ]; then
		. ${STAGING_LIBDIR}${PERL_OWN_DIR}/perl/config.sh
		# Use find since there can be a Makefile generated for each Makefile.PL
		for f in `find -name Makefile.PL`; do
			f2=`echo $f | sed -e 's/.PL//'`
			test -f $f2 || continue
			sed -i -e "s:\(PERL_ARCHLIB = \).*:\1${PERL_ARCHLIB}:" \
				-e 's/perl.real/perl/' \
				-e "s|^\(CCFLAGS =.*\)|\1 ${CFLAGS}|" \
				$f2
		done
	fi
}

cpan_do_compile () {
	oe_runmake PASTHRU_INC="${CFLAGS}" LD="${CCLD}"
}

cpan_do_install () {
	oe_runmake DESTDIR="${D}" install_vendor
	for PERLSCRIPT in `grep -rIEl '#!${bindir}/perl-native.*/perl' ${D}`; do
		sed -i -e 's|^#!${bindir}/perl-native.*/perl|#!/usr/bin/env nativeperl|' $PERLSCRIPT
	done
}

EXPORT_FUNCTIONS do_configure do_compile do_install
