DEFAULTTUNE ?= "armv7a"

TUNEVALID[armv7a] = "Enable instructions for ARMv7-a"
TUNECONFLICTS[armv7a] = "armv4 armv5 armv6 armv7"
TUNE_CCARGS .= "${@bb.utils.contains("TUNE_FEATURES", "armv7a", " -march=armv7-a", "", d)}"
MACHINEOVERRIDES =. "${@bb.utils.contains("TUNE_FEATURES", "armv7a", "armv7a:", "" ,d)}"

require conf/machine/include/arm/arch-armv6.inc
require conf/machine/include/arm/feature-arm-neon.inc

# Little Endian base configs
AVAILTUNES += "armv7a armv7at armv7a-neon armv7at-neon"
ARMPKGARCH_tune-armv7a ?= "armv7a"
ARMPKGARCH_tune-armv7at ?= "armv7a"
ARMPKGARCH_tune-armv7a-neon?= "armv7a"
ARMPKGARCH_tune-armv7at-neon ?= "armv7a"
TUNE_FEATURES_tune-armv7a ?= "armv7a vfp"
TUNE_FEATURES_tune-armv7at ?= "${TUNE_FEATURES_tune-armv7a} thumb"
TUNE_FEATURES_tune-armv7a-neon ?= "${TUNE_FEATURES_tune-armv7a} neon"
TUNE_FEATURES_tune-armv7at-neon ?= "${TUNE_FEATURES_tune-armv7at} neon"
PACKAGE_EXTRA_ARCHS_tune-armv7a = "${PACKAGE_EXTRA_ARCHS_tune-armv6} armv7a armv7a-vfp"
PACKAGE_EXTRA_ARCHS_tune-armv7a-neon = "${PACKAGE_EXTRA_ARCHS_tune-armv7a} armv7a-vfp-neon"
PACKAGE_EXTRA_ARCHS_tune-armv7at = "${PACKAGE_EXTRA_ARCHS_tune-armv6t} armv7a armv7a-vfp armv7at2-vfp"
PACKAGE_EXTRA_ARCHS_tune-armv7at-neon = "${PACKAGE_EXTRA_ARCHS_tune-armv7at} armv7a-vfp-neon armv7at2-vfp-neon"

# VFP Tunes
AVAILTUNES += "armv7ahf armv7athf armv7ahf-neon armv7athf-neon armv7ahf-neon-vfpv4 armv7athf-neon-vfpv4"
ARMPKGARCH_tune-armv7ahf ?= "armv7a"
ARMPKGARCH_tune-armv7athf ?= "armv7a"
ARMPKGARCH_tune-armv7ahf-neon?= "armv7a"
ARMPKGARCH_tune-armv7athf-neon ?= "armv7a"
ARMPKGARCH_tune-armv7ahf-neon-vfpv4 ?= "armv7a"
ARMPKGARCH_tune-armv7athf-neon-vfpv4 ?= "armv7a"
TUNE_FEATURES_tune-armv7ahf ?= "${TUNE_FEATURES_tune-armv7a} callconvention-hard"
TUNE_FEATURES_tune-armv7athf ?= "${TUNE_FEATURES_tune-armv7at} callconvention-hard"
TUNE_FEATURES_tune-armv7ahf-neon ?= "${TUNE_FEATURES_tune-armv7a-neon} callconvention-hard"
TUNE_FEATURES_tune-armv7athf-neon ?= "${TUNE_FEATURES_tune-armv7at-neon} callconvention-hard"
TUNE_FEATURES_tune-armv7ahf-neon-vfpv4 ?= "${TUNE_FEATURES_tune-armv7ahf-neon} vfpv4"
TUNE_FEATURES_tune-armv7athf-neon-vfpv4 ?= "${TUNE_FEATURES_tune-armv7athf-neon} vfpv4"
PACKAGE_EXTRA_ARCHS_tune-armv7ahf = "${PACKAGE_EXTRA_ARCHS_tune-armv6hf} armv7ahf-vfp"
PACKAGE_EXTRA_ARCHS_tune-armv7athf = "${PACKAGE_EXTRA_ARCHS_tune-armv6thf} armv7ahf-vfp armv7at2hf-vfp"
PACKAGE_EXTRA_ARCHS_tune-armv7ahf-neon = "${PACKAGE_EXTRA_ARCHS_tune-armv7ahf} armv7ahf-vfp-neon"
PACKAGE_EXTRA_ARCHS_tune-armv7athf-neon = "${PACKAGE_EXTRA_ARCHS_tune-armv7athf} armv7ahf-vfp-neon armv7at2hf-vfp-neon"
PACKAGE_EXTRA_ARCHS_tune-armv7ahf-neon-vfpv4 = "${PACKAGE_EXTRA_ARCHS_tune-armv7ahf-neon} armv7ahf-vfp-neon-vfpv4"
PACKAGE_EXTRA_ARCHS_tune-armv7athf-neon-vfpv4 = "${PACKAGE_EXTRA_ARCHS_tune-armv7athf-neon} armv7athf-vfp-neon-vfpv4"

# Big Endian
AVAILTUNES += "armv7ab armv7atb armv7ab-neon armv7atb-neon"
ARMPKGARCH_tune-armv7ab ?= "armv7a"
ARMPKGARCH_tune-armv7atb ?= "armv7a"
ARMPKGARCH_tune-armv7ab-neon?= "armv7a"
ARMPKGARCH_tune-armv7atb-neon ?= "armv7a"
TUNE_FEATURES_tune-armv7ab ?= "${TUNE_FEATURES_tune-armv7a} bigendian"
TUNE_FEATURES_tune-armv7atb ?= "${TUNE_FEATURES_tune-armv7at} bigendian"
TUNE_FEATURES_tune-armv7ab-neon ?= "${TUNE_FEATURES_tune-armv7a-neon} bigendian"
TUNE_FEATURES_tune-armv7atb-neon ?= "${TUNE_FEATURES_tune-armv7at-neon} bigendian"
PACKAGE_EXTRA_ARCHS_tune-armv7ab = "${PACKAGE_EXTRA_ARCHS_tune-armv6b} armv7ab-vfp"
PACKAGE_EXTRA_ARCHS_tune-armv7atb = "${PACKAGE_EXTRA_ARCHS_tune-armv6tb} armv7ab-vfp armv7at2b-vfp"
PACKAGE_EXTRA_ARCHS_tune-armv7ab-neon = "${PACKAGE_EXTRA_ARCHS_tune-armv7ab} armv7ab-vfp-neon"
PACKAGE_EXTRA_ARCHS_tune-armv7atb-neon = "${PACKAGE_EXTRA_ARCHS_tune-armv7atb} armv7ab-vfp-neon armv7at2b-vfp-neon"

# Big Endian + VFP
AVAILTUNES += "armv7ahfb armv7athfb armv7ahfb-neon armv7athfb-neon"
ARMPKGARCH_tune-armv7ahfb ?= "armv7a"
ARMPKGARCH_tune-armv7athfb ?= "armv7a"
ARMPKGARCH_tune-armv7ahfb-neon?= "armv7a"
ARMPKGARCH_tune-armv7athfb-neon ?= "armv7a"
TUNE_FEATURES_tune-armv7ahfb ?= "${TUNE_FEATURES_tune-armv7ahf} bigendian"
TUNE_FEATURES_tune-armv7athfb ?= "${TUNE_FEATURES_tune-armv7athf} bigendian"
TUNE_FEATURES_tune-armv7ahfb-neon ?= "${TUNE_FEATURES_tune-armv7ahf-neon} bigendian"
TUNE_FEATURES_tune-armv7athfb-neon ?= "${TUNE_FEATURES_tune-armv7athf-neon} bigendian"
PACKAGE_EXTRA_ARCHS_tune-armv7ahfb = "${PACKAGE_EXTRA_ARCHS_tune-armv6hfb} armv7ahfb-vfp"
PACKAGE_EXTRA_ARCHS_tune-armv7athfb = "${PACKAGE_EXTRA_ARCHS_tune-armv6thfb} armv7ahfb-vfp armv7at2hfb-vfp"
PACKAGE_EXTRA_ARCHS_tune-armv7ahfb-neon = "${PACKAGE_EXTRA_ARCHS_tune-armv7ahfb} armv7ahfb-vfp-neon"
PACKAGE_EXTRA_ARCHS_tune-armv7athfb-neon = "${PACKAGE_EXTRA_ARCHS_tune-armv7athfb} armv7ahfb-vfp-neon armv7at2hfb-vfp-neon"
