# redefine mkfs.jffs2 command and remove --faketime option so we get non-zero file times
# having file mod times of zero confuses cron
IMAGE_CMD_jffs2 = "mkfs.jffs2 --root=${IMAGE_ROOTFS} --output=${IMGDEPLOYDIR}/${IMAGE_NAME}${IMAGE_NAME_SUFFIX}.jffs2 ${EXTRA_IMAGECMD}"

# set specified mtadm password in image using MTADM_PASSWORD_HASH
mlinux_set_root_password () {
    echo IMAGE_ROOTFS is ${IMAGE_ROOTFS} >/tmp/m_set_root_pwd.txt
    ls ${IMAGE_ROOTFS} >/tmp/ls_pwd.txt
    if [ -e ${IMAGE_ROOTFS}/etc/shadow ]; then
        sed -i 's%^mtadm:[^:]*:%mtadm:${MTADM_PASSWORD_HASH}:%' ${IMAGE_ROOTFS}/etc/shadow
    elif [ -e ${IMAGE_ROOTFS}/etc/passwd ]; then
        sed -i 's%^mtadm:[^:]*:%mtadm:${MTADM_PASSWORD_HASH}:%' ${IMAGE_ROOTFS}/etc/passwd
    fi
}
ROOTFS_POSTPROCESS_COMMAND += "mlinux_set_root_password;"

# set custom product sw version to /etc/issue file 
mlinux_set_product_version () {
    PREV_DIR=$(pwd)
    cd "$TOPDIR"
    PRODUCT_VER=$(git describe)
    cd "$PREV_DIR"
    PRODUCT_DATE=$(date +%Y-%m-%dT%H:%M:%S)

    if [ -n "${PRODUCT_VER}" ]; then
        # set issue
        if cat ${IMAGE_ROOTFS}/etc/issue | grep "Version: " > /dev/null 2>&1 ; then
            # replace
            sed -i "s/^Version: .*$/Version: $PRODUCT_VER/g" ${IMAGE_ROOTFS}/etc/issue
            sed -i "s/^Date: .*$/Date: $PRODUCT_DATE/g" ${IMAGE_ROOTFS}/etc/issue
        else
            # add
            echo "" >> ${IMAGE_ROOTFS}/etc/issue
            echo "Version: ${PRODUCT_VER}" >> ${IMAGE_ROOTFS}/etc/issue
            echo "Date: $(date +%Y-%m-%dT%H:%M:%S)" >> ${IMAGE_ROOTFS}/etc/issue
        fi
    fi
}
ROOTFS_POSTPROCESS_COMMAND += "mlinux_set_product_version;"

# generate upgrade.bin files -- provides single file for upgrades
do_firmware () {
    cd ${DEPLOY_DIR_IMAGE}
    rm -f bstrap.bin* uboot.bin* uImage.bin* rootfs.jffs2* model

    cp at91bootstrap_pmecc_padded.bin bstrap.bin
    cp u-boot-${MACHINE}.bin uboot.bin
    cp uImage-${MACHINE}.bin uImage.bin
    cp ${IMAGE_BASENAME}-${MACHINE}.jffs2 rootfs.jffs2

    cat bstrap.bin | md5sum > bstrap.bin.md5
    cat uboot.bin | md5sum > uboot.bin.md5
    cat uImage.bin | md5sum > uImage.bin.md5
    cat rootfs.jffs2 | md5sum > rootfs.jffs2.md5

    echo "${MACHINE}" > model

    tar cvf ${IMAGE_BASENAME}-${MACHINE}-upgrade.bin uImage.bin* rootfs.jffs2* model
    tar cvf ${IMAGE_BASENAME}-${MACHINE}-upgrade-withboot.bin bstrap.bin* uboot.bin* uImage.bin* rootfs.jffs2* model
    rm -f bstrap.bin* uboot.bin* uImage.bin* rootfs.jffs2* model
}

addtask firmware after do_image_complete before do_build

# make links to images in TFTPBOOT_DIR for ease of development
do_tftpboot_links() {
    TFTPBOOT_CLEAN="oe_bootstrap.bin oe_bootstrap_pmecc_padded.bin \
                    oe_u-boot.bin oe_uImage.bin oe_rootfs.jffs2 oe_images oe_upgrade.bin oe_upgrade-withboot.bin"

    if [ -n "${TFTPBOOT_DIR}" ]; then
        install -d ${DEPLOY_DIR_IMAGE}

        for f in ${TFTPBOOT_CLEAN}; do
            rm -f ${TFTPBOOT_DIR}/$f
        done

        ln -nfs ${DEPLOY_DIR_IMAGE}/at91bootstrap.bin ${TFTPBOOT_DIR}/oe_bootstrap.bin
        if [ -f ${DEPLOY_DIR_IMAGE}/at91bootstrap_pmecc_padded.bin ]; then
            ln -nfs ${DEPLOY_DIR_IMAGE}/at91bootstrap_pmecc_padded.bin ${TFTPBOOT_DIR}/oe_bootstrap_pmecc_padded.bin
        fi
        ln -nfs ${DEPLOY_DIR_IMAGE}/u-boot-${MACHINE}.bin ${TFTPBOOT_DIR}/oe_u-boot.bin
        ln -nfs ${DEPLOY_DIR_IMAGE}/uImage-${MACHINE}.bin ${TFTPBOOT_DIR}/oe_uImage.bin
        ln -nfs ${DEPLOY_DIR_IMAGE}/${IMAGE_BASENAME}-${MACHINE}.jffs2 ${TFTPBOOT_DIR}/oe_rootfs.jffs2
        ln -nfs ${DEPLOY_DIR_IMAGE}/${IMAGE_BASENAME}-${MACHINE}-upgrade.bin ${TFTPBOOT_DIR}/oe_upgrade.bin
        ln -nfs ${DEPLOY_DIR_IMAGE}/${IMAGE_BASENAME}-${MACHINE}-upgrade-withboot.bin ${TFTPBOOT_DIR}/oe_upgrade-withboot.bin
        ln -nfs ${DEPLOY_DIR_IMAGE} ${TFTPBOOT_DIR}/oe_images
    fi
}
addtask tftpboot_links after do_firmware before do_build
