#!/bin/sh
# This scripts follows old school option rules, and all
# options must come before parameters.  Four parameters
# are required.  Options requiring parameters must be
# followed by their parameter, with or without a space.
# Options not requiring parameters can be ganged, and may
# precede a single option requiring a parameter.
# 
MYNAME=cdteep.sh
out="/sys/bus/i2c/devices/0-0056/eeprom"
vendor_id="Multi-Tech Systems"
hw_version="MTCDT-0.1"


# Set the MTCDT EEPROM
function usage {
  echo "${MYNAME}"' -d -g -b "bt_mac_addr" -w "wifi_mac_addr" -i "imei number" -l "product-id" "device-id" "uuid" "eth_mac_addr"' >&2
  cat <<!EOF >&2
  assumptions:
    All options are optional and must come first.
    -b and -w require a following mac address
    -d displays the PROM, do not write.  Ignores other parameters.
    -g GPS capability.
    -l lora capability.
    -i requires a following imei number
    
    Example
    cdteep.sh -lb 01:12:AB:C3:23:FE MTCDT-210L 3489235379 125-6356-2283-9792 12:34:AB:CD:8F:34
    To add wifimac and remove lora:
    ${MYNAME} -b 01:12:AB:C3:23:FE -w 04:16:3C:C3:45:75 MTCDT-210L 3489235379 125-6356-2283-9792 12:34:AB:CD:8F:34
        
    product-id, device-id, uuid and eth_mac_addr are required.
    
    -d          display EEPROM
    -g          capa-GPS
    -l          capa-Lora
    The following fields are fixed:
    out-file    ${out}
    vendor-id   ${vendor_id}
    hw-version  ${hw_version}
!EOF
  exit 1
}

((display=0))

while getopts b:dgw:i:l opt ; do
echo looking at opt $opt
  case $opt in
  b)
    bt_mac_addr="$OPTARG"
    barg="--mac-bluetooth ${OPTARG} --capa-bluetooth"
    ;;
  w)
    wifi_mac_addr="$OPTARG"
    warg="--mac-wifi ${OPTARG} --capa-wifi"
    ;;
  i)
    imei="$OPTARG"
    if ((${#imei} == 0)) ; then
	echo "i option requires an imei number." >&2
	usage
    fi
    iarg="--imei ${OPTARG}"
    ;;
  l)
    larg="--capa-lora"
    ;;
  d)
    echo -e "\n\nEEPROM contents"
    echo    "-----------------"
    mts-id-eeprom --in-file $out
    exit
    ;;
  g)
    gps="--capa-gps"
    ;;
 \?)
    usage
    ;;
 :)
    echo "Option -$OPTARG requires an argument." >&2
    usage
    ;;
  esac
done


shift $((OPTIND-1))

if (($# != 4)) ; then
  echo Need 4 parameters beyond the options. >&2
  echo "You specified $#." >&2
  usage
  exit 1
fi
product_id=$1
device_id=$2
uuid=$3
mac=$4

mts-id-eeprom --out-file $out --out-format bin --vendor-id "$vendor_id" \
  --product-id "$product_id" --device-id "$device_id" \
  --hw-version "$hw_version" --mac-addr $mac \
  ${warg} ${barg} \
  ${iarg} ${larg} ${gps} --uuid "$uuid"

echo -e "\n\nNew contents"
echo    "-----------------"
mts-id-eeprom --in-file $out
