# THIS RECIPE FOR PICOCELL USES PATCHED LORA NETWORK SERVER THAT SUPPORTS
# MTCAP HARDWARE AND V2 PACKET FORWARDER PROTOCOL
DESCRIPTION = "MultiTech LoRa Network Server"
PRIORITY = "optional"
SECTION = "console/utils"
LICENSE = "Proprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=7ffae4666a986c4ccf45e99e464f8402"
DEPENDS = "jsoncpp libmts mosquitto sqlite3"
RDEPENDS_${PN} += "lora-packet-forwarder logrotate"
PR = "r2"

SRC_URI = "http://multitech.net/downloads/lora-network-server_${TUNE_PKGARCH}_${PV}.tar.gz \
           file://lora-network-server.conf \
           file://lora-network-server.init \
           file://lora-network-server.default \
           file://lora-network-server.logrotate.conf \
           file://local_conf.json \
          "

SRC_URI[md5sum] = "3169970ea9b96656847d7472a2cf1f0f"
SRC_URI[sha256sum] = "81b3c348911464fccbb70e3ff0c60dbcf77af69c2205aec3591fc2ceff7a5c52"

# binaries are already stripped, so suppress warning
INSANE_SKIP_${PN} = "already-stripped"

S = "${WORKDIR}"

LORA_DIR = "/opt/lora"

do_compile() {
}

do_install() {
    install -d ${D}${LORA_DIR}
    install -m 0755 lora-network-server ${D}${LORA_DIR}/
    install -m 0644 ${WORKDIR}/lora-network-server.conf ${D}${LORA_DIR}/
    install -m 0755 ${WORKDIR}/local_conf.json ${D}${LORA_DIR}/

    install -d ${D}${sysconfdir}/default
    install -m 0644 ${WORKDIR}/lora-network-server.default ${D}${sysconfdir}/default/lora-network-server
    install -d ${D}${sysconfdir}/init.d
    install -m 0755 ${WORKDIR}/lora-network-server.init ${D}${sysconfdir}/init.d/lora-network-server
    install -d ${D}${sysconfdir}/logrotate.d
    install -m 0644 ${WORKDIR}/lora-network-server.logrotate.conf ${D}${sysconfdir}/logrotate.d/lora-network-server.conf
}

CONFFILES_${PN} = "${sysconfdir}/default/lora-network-server"
FILES_${PN} += "${LORA_DIR}"
FILES_${PN}-dbg += "${LORA_DIR}/.debug"
