DESCRIPTION = "MultiTech LoRa Network Server"
PRIORITY = "optional"
SECTION = "console/utils"
LICENSE = "Proprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=7ffae4666a986c4ccf45e99e464f8402"
DEPENDS = "jsoncpp libmts mosquitto sqlite3"
RDEPENDS_${PN} += "lora-packet-forwarder logrotate bash"
PR = "r1"

SRC_URI = "http://multitech.net/downloads/lora-network-server_${TUNE_PKGARCH}_${PV}.tar.gz \
           file://lora-network-server.init \
           file://lora-network-server.default \
           file://lora-network-server.logrotate.conf \
          "

SRC_URI[md5sum] = "4c36ae56ee05696551ebc4f7860bd3cd"
SRC_URI[sha256sum] = "0dc3a979762bd5fbd0bd7d18aaa247aa7ca619f6c13c592924cd4827b0dcb82c"

# binaries are already stripped, so suppress warning
INSANE_SKIP_${PN} = "already-stripped"

S = "${WORKDIR}"

LORA_DIR = "/opt/lora"

do_compile() {
}

inherit update-rc.d

INITSCRIPT_NAME = "lora-network-server"
INITSCRIPT_PARAMS = "defaults 80 30"

do_install() {
    install -d ${D}${LORA_DIR}
    install -m 0755 lora-network-server ${D}${LORA_DIR}/
    install -m 0644 lora-network-server.conf.sample ${D}${LORA_DIR}/lora-network-server.conf.sample

    install -d ${D}${sysconfdir}/default
    install -m 0644 ${WORKDIR}/lora-network-server.default ${D}${sysconfdir}/default/lora-network-server
    install -d ${D}${sysconfdir}/init.d
    install -m 0755 ${WORKDIR}/lora-network-server.init ${D}${sysconfdir}/init.d/lora-network-server
    install -d ${D}${sysconfdir}/logrotate.d
    install -m 0644 ${WORKDIR}/lora-network-server.logrotate.conf ${D}${sysconfdir}/logrotate.d/lora-network-server.conf
}

CONFFILES_${PN} = "${sysconfdir}/default/lora-network-server"
FILES_${PN} += "${LORA_DIR}"
FILES_${PN}-dbg += "${LORA_DIR}/.debug"
