require openssl.inc

# For target side versions of openssl enable support for OCF Linux driver
# if they are available.
DEPENDS += "cryptodev-linux"

CFLAG += "-DHAVE_CRYPTODEV -DUSE_CRYPTODEV_DIGESTS"
CFLAG_append_class-native = " -fPIC"

LIC_FILES_CHKSUM = "file://LICENSE;md5=27ffa5d74bb5a337056c14b2ef93fbf6"

export DIRS = "crypto ssl apps engines"
export OE_LDFLAGS="${LDFLAGS}"
PR = "bpo8.1"
SRC_URI += "file://run-ptest \
            file://openssl-c_rehash.sh \
            file://configure-targets.patch \
            file://shared-libs.patch \
            file://oe-ldflags.patch \
            file://engines-install-in-libdir-ssl.patch \
            file://debian_bpo8+1/debian-targets.patch \
            file://debian_bpo8+1/man-dir.patch \
            file://debian_bpo8+1/man-section.patch \
            file://debian_bpo8+1/no-rpath.patch \
            file://debian_bpo8+1/no-symbolic.patch \
            file://debian_bpo8+1/pic.patch \
            file://debian_bpo8+1/stddef.patch \
            file://debian_bpo8+1/version-script.patch \
            file://debian_bpo8+1/c_rehash-compat.patch \
            file://debian_bpo8+1/block_diginotar.patch \
            file://debian_bpo8+1/block_digicert_malaysia.patch \
            file://debian_bpo8+1/disable_freelist.patch \
            file://debian_bpo8+1/Mark-3DES-and-RC4-ciphers-as-weak.patch \
            file://debian/ca.patch \
            file://openssl_fix_for_x32.patch \
            file://fix-cipher-des-ede3-cfb1.patch \
            file://openssl-avoid-NULL-pointer-dereference-in-EVP_DigestInit_ex.patch \
            file://find.pl \
            file://openssl-fix-des.pod-error.patch \
            file://Makefiles-ptest.patch \
            file://ptest-deps.patch \
            file://openssl-1.0.2a-x32-asm.patch \
            file://ptest_makefile_deps.patch  \
            file://configure-musl-target.patch \
            file://parallel.patch \
            file://openssl-util-perlpath.pl-cwd.patch \
           "
SRC_URI[md5sum] = "f965fc0bf01bf882b31314b61391ae65"
SRC_URI[sha256sum] = "6b3977c61f2aedf0f96367dcfb5c6e578cf37e7b8d913b4ecb6643c3cb88d8c0"

PACKAGES =+ " \
  ${PN}-engines \
  ${PN}-engines-dbg \
  "
  
FILES_${PN}-engines = "${libdir}/ssl/engines/*.so ${libdir}/engines"
FILES_${PN}-engines-dbg = "${libdir}/ssl/engines/.debug"

PARALLEL_MAKE = ""
PARALLEL_MAKEINST = ""

do_configure_prepend() {
  cp ${WORKDIR}/find.pl ${S}/util/find.pl
}

# The crypto_use_bigint patch means that perl's bignum module needs to be
# installed, but some distributions (for example Fedora 23) don't ship it by
# default.  As the resulting error is very misleading check for bignum before
# building.
do_configure_prepend() {
	if ! perl -Mbigint -e true; then
		bbfatal "The perl module 'bignum' was not found but this is required to build openssl.  Please install this module (often packaged as perl-bignum) and re-run bitbake."
	fi
}
