SUMMARY = "Configuration files for online package repositories aka feeds"
PR = "r1"
LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://${COREBASE}/meta/COPYING.MIT;md5=3da9cfbcb788c80a0384361b4de20420"

feeds="all ${TUNE_PKGARCH} ${MACHINE_ARCH}"
feed_file="mlinux-feed.conf"

do_compile() {
    mkdir -p ${S}/${sysconfdir}/opkg
    rm -f ${S}/${sysconfdir}/opkg/${feed_file}
    for feed in ${feeds}; do
        echo "src/gz ${DISTRO_FEED_PREFIX}-${feed} ${DISTRO_FEED_URI}/${feed}" >> ${S}/${sysconfdir}/opkg/${feed_file}
    done
}
do_install () {
    install -d ${D}${sysconfdir}/opkg
    install -m 0644 ${S}/${sysconfdir}/opkg/* ${D}${sysconfdir}/opkg/
}

PACKAGE_ARCH = "${MACHINE_ARCH}"

CONFFILES_${PN} += "${sysconfdir}/opkg/${feed_file}"
