DESCRIPTION = "Provides default system config files and /var/config fs"
SECTION = "base"
LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/MIT;md5=0835ade698e0bcf8506ecda2f7b4f302"
PR = "r5"

inherit update-rc.d

INITSCRIPT_NAME = "config"
INITSCRIPT_PARAMS = "start 31 S ."

SRC_URI = "\
  file://network \
  file://ppp \
  file://config.init \
"

CONFIGFILES = "network ppp"

fakeroot do_install () {
    cd ${WORKDIR}

    # default config files
    rm -f defaults.tar.gz
    chown root:root -R ${CONFIGFILES}
    tar czf defaults.tar.gz ${CONFIGFILES}
    install -d ${D}${sysconfdir}
    install -m 0644 ${WORKDIR}/defaults.tar.gz ${D}${sysconfdir}/defaults.tar.gz

    # save root password for resetting to defaults
    echo -n '${MTADM_PASSWORD_HASH}' > ${D}${sysconfdir}/default_pass
    chmod 400 ${D}${sysconfdir}/default_pass

    # init script
    install -d ${D}${sysconfdir}/init.d
    install -m 0755 ${WORKDIR}/config.init ${D}${sysconfdir}/init.d/config
}

FILES_${PN} = "${sysconfdir}/defaults.tar.gz ${sysconfdir}/default_pass"
FILES_${PN} += "${sysconfdir}/init.d/config"
