SUMMARY = "Add mtadm user"
DESCRIPTION = "Add mtadm user for security purposes"
SECTION = "mtadm"
PR = "r1"
LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://${COREBASE}/LICENSE;md5=4d92cd373abda3937c2bc47fbc49d690 \
                    file://${COREBASE}/meta/COPYING.MIT;md5=3da9cfbcb788c80a0384361b4de20420"

S = "${WORKDIR}"

inherit useradd

# You must set USERADD_PACKAGES when you inherit useradd. This
# lists which output packages will include the user/group
# creation code.
#USERADD_PACKAGES = "${PN} ${PN}-user3"
USERADD_PACKAGES = "${PN}"

# You must also set USERADD_PARAM and/or GROUPADD_PARAM when
# you inherit useradd.

# GROUPADD_PARAM works the same way, which you set to the options
# you'd normally pass to the groupadd command. This will create
# groups group1 and group2:
GROUPADD_PARAM_${PN} = "-r  -g 27 sudo"

# USERADD_PARAM specifies command line options to pass to the
# useradd command. Multiple users can be created by separating
# the commands with a semicolon. Here we'll create two users,
# user1 and user2:
USERADD_PARAM_${PN} = "-u 50 -G sudo -m -r -s /bin/bash mtadm"

do_install () {
        # If the recipe doesn't have a file, the ipk
        # is deleted, and it does nothing.
        # Create a .ssh directory for mtadm.
        install -d 0700 ${D}/home/mtadm/.ssh
	chown mtadm:mtadm ${D}/home/mtadm
	chown mtadm:mtadm ${D}/home/mtadm/.ssh
}

FILES_${PN} = "/home/mtadm/.ssh"

# Prevents do_package failures with:
# debugsources.list: No such file or directory:
INHIBIT_PACKAGE_DEBUG_SPLIT = "1"

pkg_postinst_${PN} () {
   profile=/home/mtadm/.profile
   if ! grep 'sbin' ${profile} ; then
     Sub='${PA'
     Sub=${Sub}'TH}:/sbin:/usr/sbin'
     echo 'PATH='${Sub} >>/home/mtadm/.profile
     echo 'export PATH'  >>/home/mtadm/.profile
   fi
}

