DESCRIPTION = "Node-RED"
HOMEPAGE = "http://nodered.org"
LICENSE = "Apache-2.0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/Apache-2.0;md5=89aea4e17d99a7cacdbeed46a0096b10"
DEPENDS = "nodejs nodejs-native"
RDEPENDS_${PN} += "bash"
PR = "r0"

inherit npm-base


S = "${WORKDIR}"

do_install() {

    # npm install locally
    oe_runnpm install --prefix ./ node-red@0.15.3

    # npm install more stuff
    oe_runnpm install --prefix./node_modules/node-red nodemailer 
    # Build patched serialport.
    # Original is https://registry.npmjs.org/serialport/-/serialport-1.7.4.tgz
    oe_runnpm install  --prefix ./node_modules/node-red http://multitech.net/mlinux/sources/node-red-serialport-1.7.4-mt1.tgz

    # modules needed for loragw
    oe_runnpm install --prefix ./node_modules/node-red extend dissolve node-constants

    # install m2x node
    oe_runnpm install --prefix ./node_modules/node-red node-red-m2x

    # remove dupe deps
    oe_runnpm dedupe

    # remove Raspberry PI node
    rm ./node_modules/node-red/nodes/core/hardware/36-rpi-gpio.html
    rm ./node_modules/node-red/nodes/core/hardware/36-rpi-gpio.js
    rm ./node_modules/node-red/nodes/core/hardware/nrgpio
    rm ./node_modules/node-red/nodes/core/hardware/nrgpio.py

    # remove x86_64 serialport 0.0.5
    rm -rf ./node_modules/node-red/node_modules/node-red-node-serialport

    # install node-red
    install -d ${D}/opt/node-red
    cp -r ./node_modules/node-red/* ${D}/opt/node-red/
}

FILES_${PN} += "/opt/node-red"
