DESCRIPTION = "A java package to access the Capture interface of the Video4Linux API"
DEPENDS = "jpeg icedtea6-native libv4l"
PR = "r0"
LICENSE = "GPL-3.0"
LIC_FILES_CHKSUM = "file://COPYING;md5=87212b5f1ae096371049a12f80034f32"

SRC_URI = "http://v4l4j.googlecode.com/files/v4l4j-${PV}.tar.gz \
		   file://makefile.patch \
		   "

SRC_URI[md5sum] = "88756ca604a4701b7c453be24f948a09"
SRC_URI[sha256sum] = "cb20aad827442960090660d85f9fa24eed9417e732fdefb66e57083df3c88cf7"

export JDK_HOME = "${STAGING_LIBDIR_NATIVE}/jvm/icedtea6-native"
STAGING_DATADIR_JAVA_NATIVE = "${STAGING_DATADIR_NATIVE}/java"

# run ant with icedtea6-native so things get compiled with java 1.6
ANT = "${JDK_HOME}/bin/java \
	   -cp ${STAGING_DATADIR_JAVA_NATIVE}/ant.jar:${JDK_HOME}/lib/tools.jar \
	   org.apache.tools.ant.launch.Launcher"

do_compile () {
	${ANT} clean all
}

do_install () {
	install -d ${D}${libdir}
	install libvideo/libvideo.so.0 ${D}${libdir}

	install -d ${D}/usr/share/java
	install v4l4j.jar ${D}/usr/share/java

	install -d ${D}/usr/lib/jni
	install libv4l4j.so ${D}/usr/lib/jni
}

FILES_${PN} += "/usr/share/java /usr/lib/jni"
FILES_${PN}-dbg += "/usr/lib/jni/.debug"
