#!/bin/bash
# PPS= 1484247472.29561104 clock= 1484247990.00000000 offset= 517.704388959

trap "stty echo icanon" exit

OIFS=$IFS
IFS=$'\n'
if ! /usr/sbin/gpsd_ubx_fixed ; then
   logger -s -p user.warn "GPS does not have a fix yet.  Try again later."
   exit 1
fi
# This shell script is shaped by two things:
#   Lousy performance of sed and grep when used with gpsmon
#   Need to terminate 
# Terminate gpsmon after 10 seconds if it is our child          
(                                                               
  sleep 10                                                      
  ppid=$$                                                       
  gpsmonpid=$(ps -o pid,ppid,comm -e | egrep "[[:space:]]${ppid}[[:space:]]+gpsmon$" | sed -r 's/^[[:space:]]*([0-9]*)[[:space:]]+.*/\1/')
  if ((${#gpsmonpid})) ; then                                                                                                             
    logger -p user.info "terminating gpscat(${gpsmonpid}) with SIGTERM"                                                                   
    kill ${gpsmonpid}                                                                                                                     
  else                                                                                                                                    
    exit 0                                                                                                                                
  fi                                                                                                                                      
  sleep 2                                                                                                                                 
  gpsmonpid=$(ps -o pid,ppid,comm -e | egrep "[[:space:]]${ppid}[[:space:]]+gpsmon$" | sed -r 's/^[[:space:]]*([0-9]*)[[:space:]]+.*/\1/')
  if ((${#gpsmonpid})) ; then                                                                                                             
    logger -p user.info "terminating gpscat(${gpsmonpid}) with SIGKILL"                                                                   
    kill -9 ${gpsmonpid}                                                                                                                  
  fi                                                                                                                                      
) &                                                                                                                                       
                    
                    
epoch=$(gpsmon -a 2>&1 | ( while read ln ; do
	if [[ $ln =~ ^[[:space:]]*PPS=.*clock=[[:space:]]*([0-9]*)\. ]] ; then
		echo ${BASH_REMATCH[1]}
		break
	fi
done ))
if [[ $epoch =~ ^[0-9]+$ ]] ; then
  date +%s -s @${epoch} >/dev/null
else
  logger user.err "gpsmon output is bad."
  exit 1
fi
exit 0
