require at91bootstrap_3.5.inc

PR = "r3"

LICENSE = "custom-freely-distributable"
LIC_FILES_CHKSUM = "file://main.c;beginline=6;endline=26;md5=6fca71334c9e8b7d033296123c91437f"

SRCREV = "v${PV}"
SRC_URI = "git://github.com/linux4sam/at91bootstrap \
		file://at91bootstrap-3.5.2-add-install.patch \
		file://at91bootstrap-3.5.2-onetime-slow-clock-switch.patch \
		file://at91sam9x5_4bit_pmecc_header.bin \
		file://at91bootstrap-3.5.3-disable-rtc-interrupts.patch"

S = "${WORKDIR}/git"

SRC_URI_append_mtcdt = " file://at91bootstrap-3.5.3-mtcdt.patch "
SRC_URI_append_mtcap = " file://at91bootstrap-3.5.3-mtcdt.patch "

# generate a bootstrap file padded with the header needed for 4-bit PMECC
# The padded file can be flashed via u-boot without any need to set the PMECC header using SAM-BA
do_pad_4bit_pmecc() {
	cp -f ${WORKDIR}/at91sam9x5_4bit_pmecc_header.bin ${DEPLOY_DIR_IMAGE}/at91bootstrap_pmecc_padded.bin
	cat ${DEPLOY_DIR_IMAGE}/at91bootstrap.bin >> ${DEPLOY_DIR_IMAGE}/at91bootstrap_pmecc_padded.bin
}

do_install_append() {
	do_pad_4bit_pmecc
}

