DESCRIPTION = "at91bootstrap: loaded into internal SRAM by AT91 BootROM"
SECTION = "bootloaders"

PARALLEL_MAKE = ""

PACKAGE_ARCH = "${MACHINE_ARCH}"
EXTRA_OEMAKE = "CROSS_COMPILE=${TARGET_PREFIX} DESTDIR=${DEPLOY_DIR_IMAGE} REVISION=${PR}"

do_compile () {
	unset LDFLAGS
	unset CFLAGS
	unset CPPFLAGS

        # For Newer Yocto/Bitbake, CC does not
        # include the staging directory
        # by default
        CC="${CC} --sysroot=${STAGING_DIR_HOST}"
        LD="${LD} --sysroot=${STAGING_DIR_HOST}"

	rm -Rf ${S}/binaries
	for board in ${AT91BOOTSTRAP_BOARD} ; do
		oe_runmake mrproper CC="${CC}" LD="${LD}"
		filename=`find board -name ${board}_defconfig`
		if ! [ "x$filename" == "x" ] ; then 
			cp $filename .config
			oe_runmake CC="${CC}" LD="${LD}"
			oe_runmake install
		else
			echo "${board} could not be built"
			exit 1
		fi
	done
}
