inherit kernel
# mts class to build dtb and append to kernel image
inherit linux-append-dtb

PR = "r13"

LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://COPYING;md5=d7810fab7487fb0aad327b76f1be7cd7"

DEPENDS += "xz-native bc-native"

SRC_URI = "https://www.kernel.org/pub/linux/kernel/v3.x/linux-${PV}.tar.gz \
"

S = "${WORKDIR}/${PN}-${PV}"

COMMON_PATCHES = " \
            file://linux-3.12-gpio-expose-pullups.patch \
            file://linux-3.12-gpio-expose-deglitch.patch \
            file://linux-3.12-atmel-spi.patch \
            file://linux-3.12-atmel-mci-force-detect.patch \
            file://linux-3.12-atmel-pmecc-debug-bitflips.patch \
            file://linux-3.12-at91sam9_wdt-10second-timeout.patch \
            file://linux-3.12.27-option-telit.patch \
            file://linux-3.12-cdc-acm-ignore-exar-devices.patch \
            file://linux-3.12-release-rfcomm-port-fix.patch \
            file://linux-3.12-spi-atmel-dma-min.patch \
            file://linux-3.12-pps-gpio.patch \
	    file://linux-3.12-cadence-macb.patch \
            "

SRC_URI_append_mtcdt = "\
            ${COMMON_PATCHES} \
            file://defconfig \
            file://linux-3.12-eeprom-setup-mtcdt.patch \
            file://linux-3.12-mtcdt-device-tree.patch \
            file://linux-3.12-add-num_accessory_ports-config-option.patch \
            "

SRC_URI_append_mtcap = "\
            ${COMMON_PATCHES} \
            file://defconfig \
            file://linux-3.12-eeprom-setup-mtcdt.patch \
            file://linux-3.12-mtcap-device-tree.patch \
            file://linux-3.12-add-num_accessory_ports-config-option.patch \
            "

SRC_URI[md5sum] = "84b573a1583079df1e770210daa6c525"
SRC_URI[sha256sum] = "af56c7ba98a0ba0c3722d9ec7106830996610e6fd88e4b0c6b2b92dab88d7653"

COMPATIBLE_MACHINE = "(mtcdt|mtcap)"
DTB_APPEND_mtcdt = "mtcdt"
DTB_APPEND_mtcap = "mtcap"

# disable this on purpose for dev purposes
do_rm_work() {
	echo "skipping"
}
