#!/bin/bash
#
# Environmental variables:
# BTADDR     Bluetooth MAC address
# BTCHAN     Bluetooth Channel
# WIFIURL    WiFi test Address
# WIFIFILE   WiFi
# WPA_CONFIG Config file for wpa_supplicant.
#
BTPIDFILE=/opt/immunity/btpid
PGRP=$(ps --no-headings -o pgrp $$ | sed -r 's/[[:space:]]//g')
trap "kill -15 -${PGRP}" EXIT
HOME=/home/root
INTERFACES=/etc/network/interfaces

if [[ $1 == wifisetup ]] ; then
	wifisetup=true
else
	wifisetup=false
fi
.  /etc/default/rs9113

if [[ $COEX_MODE != 5 ]] ; then
  sed -i 's/^COEX_MODE=[0-9]*/COEX_MODE=5/' /etc/default/rs9113
fi
if ! egrep 'auto[[:space:]]+wifi0' $INTERFACES ; then
  echo '# Added for wifi testing -- tworadio.sh' >> $INTERFACES
  echo 'auto wifi0' >> $INTERFACES
fi

if ! egrep 'iface[[:space:]]+wifi0' $INTERFACES ; then
  echo '# Added for wifi testing -- tworadio.sh' >> $INTERFACES
  echo 'iface wifi0 inet dhcp' >> $INTERFACES
fi

/etc/init.d/rs9113 restart
rm -f btpid
sleep 5

echo 'Starting bluetooth -- this may take a while'
if ! $wifisetup ; then
	/opt/immunity/bluetoothXfer.sh $BTADDR $BTCHAN &
fi
BTPID=$!
while [[ $BTPID != $(cat $BTPIDFILE 2>/dev/null) ]] ; do
	sleep 1
done
echo
echo 'Bluetooth set up, now set up WiFi'
if $wifisetup ; then
        /opt/immunity/wifiXfer.sh wifisetup
else
	/opt/immunity/wifiXfer.sh "$WIFIURL" "$WIFIFILE" &
fi
WIFIPID=$!
wait $BTPID
wait $WIFIPID

