inherit update-rc.d

DR = "${DL_DIR}/rs9113-ipk"

INITSCRIPT_NAME = "rs9113"
INITSCRIPT_PARAMS = "start 50 S ."

python do_fetch_prepend () {
    # d.setVar('BB_STRICT_CHECKSUM',False)
    DR = d.getVar("DR",True)
    bb.note("DR is " + DR)

    try:
        os.mkdir(DR,0o755)
    except OSError:
        pass
    try:
      ex = "export SSH_AUTH_SOCK=" + d.getVar("SSH_AUTH_SOCK",True)
    except TypeError:
      ex=":"
      bb.note("SSH_AUTH_SOCK not set.  SSH keys must not use a pass phrase")
    bb.note("export is " + ex)

    gt = "git archive -v --remote=git@"

    
    gitversion = d.getVar("PV",True)

    PV = gitversion
    PV += "-"
    try:
      PV += d.getVar("MLINUX_KERNEL_VERSION",True)
    except TypeError:
      bb.fatal("MLINUX_KERNEL_VERSION missing from conf/local.conf, usually put there by setup.sh")
    try:
      PV += d.getVar("MLINUX_KERNEL_EXTRA_VERSION",True)
    except TypeError:
      bb.fatal("MLINUX_KERNEL_EXTRA_VERSION missing from conf/local.conf, usually put there by setup.sh")

    bb.note("PV is " + PV)

    ipkn = "rs9113-from-src_" + PV + ".0_mtcdt.ipk"
    bb.note("ipkname is " + ipkn)
    bb.note ("ipk path is " + DR + "/" + ipkn)

    try:
      gt += d.getVar("MTS_INTERNAL_GIT",True)
    except TypeError:
      if os.path.isfile(DR + "/" + ipkn):
          return
      bb.fatal("Need " + DR + "/" + ipkn + " or set MTS_INTERNAL_GIT and add it to BB_ENV_EXTRAWHITE")

    gt += ":mlinux/ipk.git " + gitversion
    bb.note("git is " + gt)
    tar = "tar -vx --strip-components 1 -C " + DR + " rs9113/" + ipkn
    bb.note("tar is " + tar)
    os.system(ex + ";" + gt + "|" + tar)
}

MR = "${WORKDIR}/rs9113"
do_install () {
   bbnote "pwd,ls: $(pwd) $(ls) WORKDIR is ${WORKDIR}"
   (
    cd ${WORKDIR}
    find etc -print0 | cpio -0 -pdum ${D}
    find usr -print0 | cpio -0 -pdum ${D}
    find opt -print0 | cpio -0 -pdum ${D}
   )
   install -d ${D}/opt/rs9113/init.d
   install -d ${D}${sysconfdir}/init.d/
   install -d ${D}${sysconfdir}/default/
   install -m 0755 ${MR}/wpa_supplicant ${D}/opt/rs9113/init.d
   install -m 0755 ${MR}/rs9113.init ${D}${sysconfdir}/init.d/rs9113
   install -m 0644 ${MR}/rs9113.default ${D}${sysconfdir}/default/rs9113
}

python do_cleanall_prepend () {
    bb.note("In do_clean_prepend")
    DR = d.getVar("DR",True)
    bb.note("About to delete " + DR)
    os.system("/bin/rm -rf " + DR)
}

