﻿using System;
using System.IO;
using System.Net;
using System.Text;

namespace Examples.System.Net
{
    public class WebRequestPostExample
    {
        public static void Main()
        {
            ServicePointManager.Expect100Continue = false;

            // Create a request using a URL that can receive a post. 
            WebRequest request = WebRequest.Create("http://216.133.69.247/ffws/v1/ofax");

            // Add authentication to request  
            request.Credentials = new NetworkCredential("admin", "admin");  

            // Set the Method property of the request to POST.
            request.Method = "POST";

            // Set the ContentType property of the WebRequest.
            request.ContentType = "application/xml";

            //Get File size
            FileInfo fileSize = new FileInfo("C:/Users/test/Documents/Visual Studio 2008/Projects/sendFax/sendFax/schedule.xml");
            int len = (int)fileSize.Length;


            // Set the ContentLength property of the WebRequest.
            request.ContentLength = len;

            // Get the request stream.
            Stream dataStream = request.GetRequestStream();

            StreamReader textIn = new StreamReader(new FileStream("C:/Users/test/Documents/Visual Studio 2008/Projects/sendFax/sendFax/schedule.xml",
                                                                    FileMode.Open,FileAccess.Read));
          
            string TextLines = textIn.ReadToEnd();
            byte[] byteArray = Encoding.UTF8.GetBytes(TextLines);
            // Write the data to the request stream.
            dataStream.Write(byteArray,0,byteArray.Length);

            textIn.Close();
            // Close the Stream object.
            dataStream.Close();

            // Get the response.
            WebResponse response = request.GetResponse();

            // Display the status.
            Console.WriteLine(((HttpWebResponse)response).StatusDescription);

            // Get the stream containing content returned by the server.
            Stream data = response.GetResponseStream();

            // Open the stream using a StreamReader for easy access.
            StreamReader reader = new StreamReader(data);

            // Read the content.
            string responseFromServer = reader.ReadToEnd();

            // Display the content.
            Console.WriteLine(responseFromServer);

            // Clean up the streams.
            reader.Close();
            data.Close();
            response.Close();
        }
    }
}