// ismsResponse.cpp : Defines the entry point for the console application.
//

//Version: $Revision: 1.2 $
#include "stdafx.h"
#include <string>
#include <iostream>
#include <malloc.h>
#include <stdlib.h>
#include <fstream>

using namespace std;

// XML Tags indices into the string array

#define MSG_NOTIFY_START	0
#define MSG_NOTIFY_END		1
#define MODEM_NUMBER_START	2
#define MODEM_NUMBER_END	3
#define SENDER_NUMBER_START 4
#define SENDER_NUMBER_END 5
#define DATE_START		6
#define DATE_END		7
#define TIME_START		8
#define TIME_END		9
#define MESSAGE_START   10
#define MESSAGE_END		11

char *SMSXMLTags[] = {
	"<MessageNotification>",
	"</MessageNotification>",
	"<ModemNumber>",
	"</ModemNumber>",
	"<SenderNumber>",
	"</SenderNumber>",
	"<Date>",
	"</Date>",
	"<Time>",
	"</Time>",
	"<Message>",
	"</Message>"
};
/*************************************************************************
 * Converts hexadecimal to decimal (character): 
 *************************************************************************/

char x2c(char *what)
{
  register char digit;
  
  digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
  digit *= 16;
  digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
  return (digit);
}

/*************************************************************************
 * Unescapes "%"-escaped characters in a query: 
 *************************************************************************/
void unescape_url(char *url)
{
  register int x,y,len;
  
  len = strlen(url);
  
  for (x=0, y=0; url[y]; ++x, ++y)
    {
      if ((url[x] = url[y]) == '%'
	  && y < len - 2)   
	{
	  url[x] = x2c(&url[y+1]);
	  y+=2;
        }
    }
  url[x] = '\0';
}

/*************************************************************************
 * Converts pluses back to spaces in a query: 
 *************************************************************************/
void plustospace(char *str)
{
  register int x;
  
  for (x=0; str[x]; x++)
    if (str[x] == '+')
      str[x] = ' ';
}


/*************************************************************************/
int _tmain(int argc, _TCHAR* argv[])
{

	
	//char *sms_data;
   char *sms_ptr, *data_ptr;
   char c, *start_ptr, *end_ptr;


   char *pContentLength;
   char *pBuffer_To_Store_Data;
   size_t len;

   string data_ready_to_write_to_file="";

   //Get query string from the send.html
   errno_t err = _dupenv_s( &pContentLength,&len,"CONTENT_LENGTH" );
   if ( err ) return -1;

   int nContentLength = atoi(pContentLength);

   //Create a memory buffer to store the data.
   pBuffer_To_Store_Data = (char *)malloc(nContentLength+1);
   //Initialize the memory with zero.
   memset(pBuffer_To_Store_Data,0,nContentLength + 1);

   //Read in data
   fgets(pBuffer_To_Store_Data,nContentLength,stdin);

   //cout << "Content-type: text/html" << endl << endl;
   
   //These two functions will clean up all the '+' and
   //'%' stuff.
   unescape_url(pBuffer_To_Store_Data);
   plustospace(pBuffer_To_Store_Data);

	// parse the SMS data for the XML tags and dump to 'receive.log'.
	
	data_ptr = pBuffer_To_Store_Data;

	while (sms_ptr = strstr(data_ptr, SMSXMLTags[MSG_NOTIFY_START])) {

	    sms_ptr = strstr(data_ptr, SMSXMLTags[MSG_NOTIFY_START]); 
		sms_ptr += strlen(SMSXMLTags[MSG_NOTIFY_START]);


		// search for beginning of '<modem number>'.
		start_ptr = strstr(sms_ptr, SMSXMLTags[MODEM_NUMBER_START]);
		//Then move the pointer to the begining of the modem number.
		start_ptr += strlen(SMSXMLTags[MODEM_NUMBER_START]);
		//Search for ending '</modem number> and then place the pointer at it.
		end_ptr = strstr(sms_ptr, SMSXMLTags[MODEM_NUMBER_END]);
		
		//We need to put a 0 to stop it when we print it out.
		//So, we temp copy the end pointer to c and then set 0 to it.
		c = *end_ptr;
		*end_ptr = 0;
		//Print it out.
		//cout << start_ptr << ",";
		data_ready_to_write_to_file.append(start_ptr);
		data_ready_to_write_to_file.append(",");
        //copy end pointer back.
		*end_ptr = c;

		// search for the sender number.
		
		start_ptr = strstr(sms_ptr, SMSXMLTags[SENDER_NUMBER_START]);
		start_ptr += strlen(SMSXMLTags[SENDER_NUMBER_START]);
		end_ptr = strstr(sms_ptr, SMSXMLTags[SENDER_NUMBER_END]);

		c = *end_ptr;
		*end_ptr = 0;

		//cout << start_ptr << ",";
		data_ready_to_write_to_file.append(start_ptr);
		data_ready_to_write_to_file.append(",");
		*end_ptr = c;

		// search for date.
		
		start_ptr = strstr(sms_ptr, SMSXMLTags[DATE_START]);
		start_ptr += strlen(SMSXMLTags[DATE_START]);
		end_ptr = strstr(sms_ptr, SMSXMLTags[DATE_END]);

		c = *end_ptr;
		*end_ptr = 0;

		//cout << start_ptr << ",";
		data_ready_to_write_to_file.append(start_ptr);
		data_ready_to_write_to_file.append(",");
		*end_ptr = c;

		// search for the Time number.
		
		start_ptr = strstr(sms_ptr, SMSXMLTags[TIME_START]);
		start_ptr += strlen(SMSXMLTags[TIME_START]);
		end_ptr = strstr(sms_ptr, SMSXMLTags[TIME_END]);

		c = *end_ptr;
		*end_ptr = 0;

		//cout << start_ptr << ",";
		data_ready_to_write_to_file.append(start_ptr);
		data_ready_to_write_to_file.append(",");
		*end_ptr = c;

		// search for the message.
		
		start_ptr = strstr(sms_ptr, SMSXMLTags[MESSAGE_START]);
		start_ptr += strlen(SMSXMLTags[MESSAGE_START]);
		end_ptr = strstr(sms_ptr, SMSXMLTags[MESSAGE_END]);

		c = *end_ptr;
		*end_ptr = 0;

		//cout << start_ptr << ",";
		data_ready_to_write_to_file.append(start_ptr);
		data_ready_to_write_to_file.append("\r\n");
		*end_ptr = c;


		data_ptr = end_ptr+1;
	}
	ofstream myfile;
	myfile.open("receive.log",ios::app);
	myfile << data_ready_to_write_to_file;
	myfile.close();
    free(pBuffer_To_Store_Data);
	return 0;
}

