﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Net;
using System.Net.Sockets;

namespace iSMSHTTPQuery
{
    class Program
    {
        static void Main(string[] args)
        {
            // Check if all arguments were sent
            if (args.Length < 4)
            {
                // Not enough arguments. Display command line syntax.
                Console.WriteLine("Command iSMSHTTPQuery usage:");
                Console.WriteLine("iSMSHTTPQuery <ipaddress> <username> <password> <messageID>");
                Console.WriteLine("iSMSHTTPQuery <ipaddress>:<port> <username> <password> <messageID>");
                return;
            }

            // Build sendmsg request string from arguments sent
            String sendmsg = "http://" + args[0] + "/querymsg?user=" + args[1] + "&passwd=" + args[2] + "&apimsgid=" + args[3];

            // Display sendmsg request being sent to iSMS.
            Console.WriteLine("\nMessage sent to iSMS:");
            Console.WriteLine(sendmsg + "\n\n");


            // Next section sends the sendmsg request to iSMS and gets the response.
            try
            {
                // prepare the web page we will be asking for
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(sendmsg);

                // execute the request
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();

                // Create a new stream to read from a response
                StreamReader sr = new StreamReader(response.GetResponseStream());
                // Read contents of response into a string
                String responseMsg = sr.ReadToEnd();
                // Close StreamReader
                sr.Close();

                // Display response from iSMS.
                Console.WriteLine("Response from iSMS:");
                Console.WriteLine(responseMsg);
            }
            catch (System.Exception e)
            {
                // Exception sending HTTP request, or getting response. 
                // Display response exception message.
                Console.WriteLine("Error sending request to iSMS:");
                Console.WriteLine(e.ToString());
            }


        }
    }
}
