#ifndef SKYEYE_NE2K_H
#define SKYEYE_NE2K_H

struct ethframe {
	unsigned char dst[ETH_ALEN];
	unsigned char src[ETH_ALEN];
	unsigned short proto;
	unsigned char data[ETH_DATA_LEN+22];
};

//#ifndef SKYEYE_NE2K_H
//#define SKYEYE_NE2K_H

#define AT91_NET_BASE    (0xfffa0000)
#define NE_BASE           AT91_NET_BASE   
#define AT91_NET_SIZE	 255
#define AT91_NET_IRQNUM	 16



//yangye 2003-1-20
//all addr[1,0] must be 00
#define NE_CR              (NE_BASE+0)             //R/WԲͬҳCRͬһ
#define	NE_DMA		   (NE_BASE+64)	     //0x10-0x10 DMA˿,ظֻ0x10.
#define	NE_RESET	   (NE_BASE+124)	     //0x180x1f λ˿ڣظֻ0x1fдλ

//page0 registers
#define NE_PSTART          (NE_BASE+4)            //Wջ廷ʼҳ
#define NE_PSTOP           (NE_BASE+8)            //Wջ廷ֹҳҳ
#define NE_BNRY            (NE_BASE+12)            //R/Wջ廷ָ룬ָһʱʼҳ,ӦʼɣCURRPSTART
#define NE_TPSR            (NE_BASE+16)            //WLocal DMAͻʼҳĴ
#define NE_TBCR0           (NE_BASE+20)            //WLocal DMAͳȵλ
#define NE_TBCR1           (NE_BASE+24)            //WLocal DMAͳȸλ
#define NE_ISR             (NE_BASE+28)            //R/Wж״̬Ĵ
#define NE_RSAR0           (NE_BASE+32)            //WRemote DMAĿʼַλ
#define NE_RSAR1           (NE_BASE+36)            //WRemote DMAĿʼַλ
//CPUдݰʵʳȣִRemote DMAǰ
#define NE_RBCR0           (NE_BASE+40)            //WRemote DMAݳȵλ
#define NE_RBCR1           (NE_BASE+44)            //WRemote DMAݳȸλ
#define NE_RCR             (NE_BASE+48)            //WüĴ,ʼʱд0x04,ʾֻշMACַ,64ֽڵ̫㲥
#define NE_TCR             (NE_BASE+52)            //üĴ,ʼʼʱд0x02ΪLoop Backģʽֹͣݰ,ʼд0x00ݰCRC
#define NE_DCR             (NE_BASE+56)            //WüĴ,ʼʱд0x488λģʽFIFO8ֽڣDMAʽ
#define NE_IMR             (NE_BASE+60)            //WжμĴĸλISRеĸλӦIMRдֵΪӦж
//page1 registers
#define NE_PAR0            (NE_BASE+4)            //R/WMACַλ
#define NE_PAR1            (NE_BASE+8)            //R/WMACַ
#define NE_PAR2            (NE_BASE+12)            //R/WMACַ
#define NE_PAR3            (NE_BASE+16)            //R/WMACַ
#define NE_PAR4            (NE_BASE+20)            //R/WMACַ
#define NE_PAR5            (NE_BASE+24)            //R/WMACַλ
#define NE_CURR            (NE_BASE+28)            //R/Wջ廷дָ
#define NE_MAR0            (NE_BASE+32)            //R/W鲥Ĵ 
#define NE_MAR1            (NE_BASE+36)            //R/W鲥Ĵ 
#define NE_MAR2            (NE_BASE+40)            //R/W鲥Ĵ 
#define NE_MAR3            (NE_BASE+44)            //R/W鲥Ĵ 
#define NE_MAR4            (NE_BASE+48)            //R/W鲥Ĵ 
#define NE_MAR5            (NE_BASE+52)            //R/W鲥Ĵ 
#define NE_MAR6            (NE_BASE+56)            //R/W鲥Ĵ 
#define NE_MAR7            (NE_BASE+60)            //R/W鲥Ĵ 
 
//page2 registers (read only in 8019as)
//#define NE_PSTART          0x01            //Rջ廷ʼҳ
//#define NE_PSTOP           0x02            //Rջ廷ֹҳҳ
//#define NE_TPSR            0x04            //RLocal DMAͻʼҳĴ
//#define NE_RCR             0x0c            //RüĴ
//#define NE_TCR             0x0d            //R,üĴ
//#define NE_DCR             0x0e            //RüĴ
//#define NE_IMR             0x0f            //RжμĴIMR״̬


//CRĴ 
#define	CMD_STOP	0x01       //ֹͣշ
#define	CMD_RUN	    	0x02       //ִʼշݰΪ֣
#define	CMD_XMIT	0x04       //Local DMA SENDDD>̫ 
#define	CMD_READ	0x08       //Remote DMA READֶݣDD>CPU
#define	CMD_WRITE	0x10       //Remote DMA WRITE <DDCPU
#define	CMD_SEND	0x18       //SEND COMMANDԶݰ                                      DD>CPU
#define	CMD_NODMA	0x20       //ֹͣDMA
#define	CMD_PAGE0	0x00       //   ѡ0ҳҪѡҳٶдҳĴ
#define	CMD_PAGE1	0x40       //   ѡ1ҳ
#define	CMD_PAGE2	0x80       //   ѡ2ҳ

//дTPSRֵ 
#define	XMIT_START	 0x4000       //ͻʼַдʱҪ8λõҳţ
//дPSTARTֵ 
#define	RECV_START	 0x4600       //ջʼַдʱҪ8λõҳţ
//дPSTOPֵ 
#define	RECV_STOP	 0x6000       //ջַдʱҪ8λõҳţ

//ж״̬Ĵֵ 
#define	ISR_PRX	    	0x01       //ȷݰжϡմ
#define	ISR_PTX		0x02       //ȷݰжϡҪϲˡ
#define	ISR_RXE	    	0x04       //ݰBNRYCURR 
#define	ISR_TXE	    	0x08       //ڳͻ࣬ͳط
#define	ISR_OVW	    	0x10       //ڴֲᡣ
#define	ISR_CNT	    	0x20       //жϣεIMRĴ
#define	ISR_RDC	    	0x40       //Remote DMA εѯȴDMA
#define	ISR_RST		0x80       //Resetε

//жμĴֵ 
#define	ISR_PRX	    	0x01
#define	ISR_PTX		0x02
#define	ISR_RXE	    	0x04
#define	ISR_TXE	    	0x08
#define	ISR_OVW	    	0x10
#define	ISR_CNT 	0x20
#define	ISR_RDC	    	0x40
#define	ISR_RST		0x80

//ݿƼĴ
//ʼʱд0x488λģʽFIFO8ֽڣDMAʽ
#define	DCR_WTS		0x01
#define	DCR_BOS		0x02
#define	DCR_LAS		0x04
#define	DCR_LS		0x08
#define	DCR_ARM		0x10
#define	DCR_FIFO2	0x00
#define	DCR_FIFO4	0x20
#define	DCR_FIFO8	0x40
#define	DCR_FIFO12	0x60

//TCRüĴ
//ʼʼʱд0x02ΪLoop Backģʽֹͣݰ
//ʼд0x00ݰCRC
#define	TCR_CRC		0x01
#define	TCR_LOOP_NONE	0x00
#define	TCR_LOOP_INT	0x02
#define	TCR_LOOP_EXT	0x06
#define	TCR_ATD		0x08
#define	TCR_OFST	0x10

//RCRüĴ
//ʼʱд0x04ֻշMACַ64ֽڵ̫㲥
#define	RCR_SEP		0x01
#define	RCR_AR		0x02
#define	RCR_AB		0x04
#define	RCR_AM		0x08
#define	RCR_PRO		0x10
#define	RCR_MON		0x20


#endif /* SKYEYE_NE2K_H */
