/*
 * linux/drivers/video/s1d13806fb.h
 *	-- Support for the Epson SED13806 LCD/CRT controller
 *
 * Copyright (C) 2003 Heiko Degenhardt <linux@sentec-elektronik.de>
 *                    Michael Huhn <michael.huhn@sentec-elektronik.de>
 *
 * Some ideas were "stolen" from
 *    linux/drivers/video/epson1355fb.c
 *    that is "Copyright (C) 2000 Philipp Rumpf <prumpf@tux.org>"
 * and from s1d13xxxfb.c and a file called "s1d13806.h" that was
 *    generated by S1D13806CFG.EXE both are
 *    "Copyright(c) 2000, 2001 Epson Research and Development, Inc"
 *
 * HINT: If someone feels that we used his code but didn't give him
 * credits here, please email us! It was a quite complicated thing to
 * get all that working, so may be we just forgot someone! Thanks!
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file COPYING in the main directory of this archive
 * for more details.
 */

/*
 * CHANGES
 *
 * 20040205
 * - Changed memory size (thanks to Matthias Babylon)
 * - Added S1D13806_GPIO_CONFIG1_REG (needed for startup)
 * - Changed S1D13806_GPIO_CTL1_REG to 0x09 (for startup)
 * (woel, hede)
 *
 * 20030408
 *    Creation
 *    (woel, mihu)
 */

/*
 *
 * ATTENTION!
 * This stuff is _really_ experimental, currently!
 * Feedback is really welcome!
 *
 */

/* Register defines. */

#define S1D13806_REVISION_CODE_REG		0x00

/* LUT */
#define S1D13806_LUT_MODE_REG	0x01E0
#define S1D13806_LUT_ADDR_REG	0x01E2
#define S1D13806_LUT_DATA_REG	0x01E4


#define S1D13806_GPIO_CONFIG1_REG	0x05
#define S1D13806_GPIO_CTL1_REG	0x09
#define S1D13806_PANEL_TYPE_REG		0x30
#define S1D13806_DISPLAY_MODE_REG		0x40
#define S1D13806_HOR_DISPLAY_WIDTH_REG	0x32
#define S1D13806_VERT_DISPLAY_HEIGHT_REG	0x38

#define S1D13806_VERT_NONDISPLAY_PERIOD_REG	0x34
#define S1D13806_HOR_NONDISPLAY_PERIOD_REG	0x3A
#define S1D13806_TFT_LINE_START_POS_REG	0x35
#define S1D13806_LCD_MISC_REG	0x41


/* The following defines are specific for our board layout! */

#ifdef CONFIG_COBRA5272
#define S1D13806_REG_OFFSET   0x40000000
#define S1D13806_FB_OFFSET    0x200000
#define S1D13806_SRAM_SIZE		0x140000

#define S1D13806_REG_BASE	MCF_MBAR + S1D13806_REG_OFFSET
#define S1D13806_FB_BASE	S1D13806_REG_OFFSET + S1D13806_FB_OFFSET

#define S1D_PHYSICAL_REG_ADDR       S1D13806_REG_OFFSET
#define S1D_PHYSICAL_VMEM_ADDR      S1D13806_FB_BASE
#define S1D_PHYSICAL_VMEM_SIZE      0x140000L


#else
#error unknown architecture
#endif

struct s1d13806fb_info {
   struct fb_info_gen gen;
};

struct s1d13806_par {
	u32 xres;
	u32 yres;

	int bpp;
	int mem_bpp;

	u32 panel_xres;
	u32 panel_yres;

	int panel_width;
};


/* Prototypes */
static void s1d13806_detect(void);
int s1d13806fb_init(void);
int s1d13806fb_setup(char*);
static int s1d13806_encode_fix(struct fb_fix_screeninfo *fix,
				const void *raw_par,
				struct fb_info_gen *info);
static int s1d13806_set_bpp(struct s1d13806_par *par, int bpp);
static int s1d13806_decode_var(const struct fb_var_screeninfo *var,
				void *raw_par,
				struct fb_info_gen *info);
static void dump_panel_data(void);
static int s1d13806_bpp_to_var(int bpp, struct fb_var_screeninfo *var);
static int s1d13806_encode_var(struct fb_var_screeninfo *var,
				const void *raw_par,
				struct fb_info_gen *info);
static void get_panel_data(struct s1d13806_par *par);
static void s1d13806_get_par(void *raw_par, struct fb_info_gen *info);
static void s1d13806_set_par(const void *par, struct fb_info_gen *info);
static int s1d13806_getcolreg(unsigned regno, unsigned *red, unsigned *green,
				unsigned *blue, unsigned *transp,
				struct fb_info *info);
static int s1d13806_setcolreg(unsigned regno, unsigned red, unsigned green,
				unsigned blue, unsigned transp,
				struct fb_info *info);
static int s1d13806_pan_display(const struct fb_var_screeninfo *var,
				struct fb_info_gen *info);
static int s1d13806_blank(int blank_mode, struct fb_info_gen *info);
static void s1d13806_set_disp(const void *unused, struct display *disp,
				struct fb_info_gen *info);
static struct s1d13806fb_info fb_info;
int __init s1d13806fb_setup(char *str);
int __init s1d13806fb_init(void);
void s1d13806fb_cleanup(struct fb_info *info);


static void set_color_bitfields(struct fb_var_screeninfo *var);
static int s1d13806_get_fix(struct fb_fix_screeninfo *fix, int con,
				struct fb_info *info);
static int s1d13806_get_var(struct fb_var_screeninfo *var, int con,
				struct fb_info *info);
static int s1d13806_set_var(struct fb_var_screeninfo *var, int con,
				struct fb_info *info);
static int s1d13806_get_cmap(struct fb_cmap *cmap, int kspc, int con,
				struct fb_info *info);
static int s1d13806_set_cmap(struct fb_cmap *cmap, int kspc, int con,
				struct fb_info *info);


/* ------------ Interfaces to hardware functions ------------ */

struct fbgen_hwswitch s1d13806_switch = {
	detect:		s1d13806_detect,
	encode_fix:	s1d13806_encode_fix,
	decode_var:	s1d13806_decode_var,
	encode_var:	s1d13806_encode_var,
	get_par:	s1d13806_get_par,
	set_par:	s1d13806_set_par,
	getcolreg:	s1d13806_getcolreg,
	setcolreg:	s1d13806_setcolreg,
	pan_display:	s1d13806_pan_display,
	blank:		s1d13806_blank,
	set_disp:	s1d13806_set_disp,
};


/* ------------ Hardware Independent Functions ------------ */

static struct fb_ops s1d13806fb_ops = {
	owner:		THIS_MODULE,
	fb_get_fix:	s1d13806_get_fix,
	fb_get_var:	s1d13806_get_var,
	fb_set_var:	s1d13806_set_var,
	fb_get_cmap:	s1d13806_get_cmap,
	fb_set_cmap:	s1d13806_set_cmap,
	fb_pan_display:	fbgen_pan_display,
};


/* The following lines are for the initialization of the controller */

typedef unsigned short S1D_INDEX;
typedef unsigned short S1D_VALUE;

typedef struct
{
    S1D_INDEX Index;
    S1D_VALUE Value;
} S1D_REGS;

static S1D_REGS aS1DRegs[] =
{
   {0x0001,    0x00},   // Miscellaneous Register
   {0x01FC,    0x00},   // Display Mode Register
   {0x0004,    0x00},   // General IO Pins Configuration Register 0
   {0x0005,    0x08},   // General IO Pins Configuration Register 1
   {0x0008,    0x00},   // General IO Pins Control Register 0
   {0x0009,    0x00},   // General IO Pins Control Register 1
   {0x0010,    0x11},   // Memory Clock Configuration Register
   {0x0014,    0x33},   // LCD Pixel Clock Configuration Register
   {0x0018,    0x01},   // CRT/TV Pixel Clock Configuration Register
   {0x001C,    0x01},   // MediaPlug Clock Configuration Register
   {0x001E,    0x00},   // CPU To Memory Wait State Select Register
   {0x0020,    0x80},   // Memory Configuration Register
   {0x0021,    0x03},   // DRAM Refresh Rate Register
   {0x002A,    0x00},   // DRAM Timings Control Register 0
   {0x002B,    0x12},   // DRAM Timings Control Register 1
   {0x0030,    0x1C},   // Panel Type Register
   {0x0031,    0x00},   // MOD Rate Register
   {0x0032,    0x27},   // LCD Horizontal Display Width Register
   {0x0034,    0x0D},   // LCD Horizontal Non-Display Period Register
   {0x0035,    0x00},   // TFT FPLINE Start Position Register
   {0x0036,    0x00},   // TFT FPLINE Pulse Width Register
   {0x0038,    0xEF},   // LCD Vertical Display Height Register 0
   {0x0039,    0x00},   // LCD Vertical Display Height Register 1
   {0x003A,    0x0A},   // LCD Vertical Non-Display Period Register
   {0x003B,    0x00},   // TFT FPFRAME Start Position Register
   {0x003C,    0x00},   // TFT FPFRAME Pulse Width Register
   {0x0040,    0x03},   // LCD Display Mode Register
   {0x0041,    0x00},   // LCD Miscellaneous Register
   {0x0042,    0x00},   // LCD Display Start Address Register 0
   {0x0043,    0x00},   // LCD Display Start Address Register 1
   {0x0044,    0x00},   // LCD Display Start Address Register 2
   {0x0046,    0xA0},   // LCD Memory Address Offset Register 0
   {0x0047,    0x00},   // LCD Memory Address Offset Register 1
   {0x0048,    0x00},   // LCD Pixel Panning Register
   {0x004A,    0x00},   // LCD Display FIFO High Threshold Control Register
   {0x004B,    0x00},   // LCD Display FIFO Low Threshold Control Register
   {0x0050,    0x00},   // CRT/TV Horizontal Display Width Register
   {0x0052,    0x00},   // CRT/TV Horizontal Non-Display Period Register
   {0x0053,    0x00},   // CRT/TV HRTC Start Position Register
   {0x0054,    0x00},   // CRT/TV HRTC Pulse Width Register
   {0x0056,    0x00},   // CRT/TV Vertical Display Height Register 0
   {0x0057,    0x00},   // CRT/TV Vertical Display Height Register 1
   {0x0058,    0x00},   // CRT/TV Vertical Non-Display Period Register
   {0x0059,    0x00},   // CRT/TV VRTC Start Position Register
   {0x005A,    0x00},   // CRT/TV VRTC Pulse Width Register
   {0x005B,    0x00},   // TV Output Control Register
   {0x0060,    0x00},   // CRT/TV Display Mode Register
   {0x0062,    0x00},   // CRT/TV Display Start Address Register 0
   {0x0063,    0x00},   // CRT/TV Display Start Address Register 1
   {0x0064,    0x00},   // CRT/TV Display Start Address Register 2
   {0x0066,    0x00},   // CRT/TV Memory Address Offset Register 0
   {0x0067,    0x00},   // CRT/TV Memory Address Offset Register 1
   {0x0068,    0x00},   // CRT/TV Pixel Panning Register
   {0x006A,    0x00},   // CRT/TV Display FIFO High Threshold Control Register
   {0x006B,    0x00},   // CRT/TV Display FIFO Low Threshold Control Register
   {0x0070,    0x00},   // LCD Ink/Cursor Control Register
   {0x0071,    0x00},   // LCD Ink/Cursor Start Address Register
   {0x0072,    0x00},   // LCD Cursor X Position Register 0
   {0x0073,    0x00},   // LCD Cursor X Position Register 1
   {0x0074,    0x00},   // LCD Cursor Y Position Register 0
   {0x0075,    0x00},   // LCD Cursor Y Position Register 1
   {0x0076,    0x00},   // LCD Ink/Cursor Blue Color 0 Register
   {0x0077,    0x00},   // LCD Ink/Cursor Green Color 0 Register
   {0x0078,    0x00},   // LCD Ink/Cursor Red Color 0 Register
   {0x007A,    0x00},   // LCD Ink/Cursor Blue Color 1 Register
   {0x007B,    0x00},   // LCD Ink/Cursor Green Color 1 Register
   {0x007C,    0x00},   // LCD Ink/Cursor Red Color 1 Register
   {0x007E,    0x00},   // LCD Ink/Cursor FIFO Threshold Register
   {0x0080,    0x00},   // CRT/TV Ink/Cursor Control Register
   {0x0081,    0x00},   // CRT/TV Ink/Cursor Start Address Register
   {0x0082,    0x00},   // CRT/TV Cursor X Position Register 0
   {0x0083,    0x00},   // CRT/TV Cursor X Position Register 1
   {0x0084,    0x00},   // CRT/TV Cursor Y Position Register 0
   {0x0085,    0x00},   // CRT/TV Cursor Y Position Register 1
   {0x0086,    0x00},   // CRT/TV Ink/Cursor Blue Color 0 Register
   {0x0087,    0x00},   // CRT/TV Ink/Cursor Green Color 0 Register
   {0x0088,    0x00},   // CRT/TV Ink/Cursor Red Color 0 Register
   {0x008A,    0x00},   // CRT/TV Ink/Cursor Blue Color 1 Register
   {0x008B,    0x00},   // CRT/TV Ink/Cursor Green Color 1 Register
   {0x008C,    0x00},   // CRT/TV Ink/Cursor Red Color 1 Register
   {0x008E,    0x00},   // CRT/TV Ink/Cursor FIFO Threshold Register
   {0x0100,    0x00},   // BitBlt Control Register 0
   {0x0101,    0x00},   // BitBlt Control Register 1
   {0x0102,    0x00},   // BitBlt ROP Code/Color Expansion Register
   {0x0103,    0x00},   // BitBlt Operation Register
   {0x0104,    0x00},   // BitBlt Source Start Address Register 0
   {0x0105,    0x00},   // BitBlt Source Start Address Register 1
   {0x0106,    0x00},   // BitBlt Source Start Address Register 2
   {0x0108,    0x00},   // BitBlt Destination Start Address Register 0
   {0x0109,    0x00},   // BitBlt Destination Start Address Register 1
   {0x010A,    0x00},   // BitBlt Destination Start Address Register 2
   {0x010C,    0x00},   // BitBlt Memory Address Offset Register 0
   {0x010D,    0x00},   // BitBlt Memory Address Offset Register 1
   {0x0110,    0x00},   // BitBlt Width Register 0
   {0x0111,    0x00},   // BitBlt Width Register 1
   {0x0112,    0x00},   // BitBlt Height Register 0
   {0x0113,    0x00},   // BitBlt Height Register 1
   {0x0114,    0x00},   // BitBlt Background Color Register 0
   {0x0115,    0x00},   // BitBlt Background Color Register 1
   {0x0118,    0x00},   // BitBlt Foreground Color Register 0
   {0x0119,    0x00},   // BitBlt Foreground Color Register 1
   {0x01E0,    0x00},   // Look-Up Table Mode Register
   {0x01E2,    0x00},   // Look-Up Table Address Register
   {0x01F0,    0x10},   // Power Save Configuration Register
   {0x01F1,    0x00},   // Power Save Status Register
   {0x01F4,    0x00},   // CPU-to-Memory Access Watchdog Timer Register
   {0x01FC,    0x01},   // Display Mode Register

   {0xffff,0xffff},   //end of the table
};


u8 LUT8_Color[256*3] =
{
/* Primary and secondary colors */
0x00, 0x00, 0x00,  0x00, 0x00, 0xA0,  0x00, 0xA0, 0x00,  0x00, 0xA0, 0xA0,
0xA0, 0x00, 0x00,  0xA0, 0x00, 0xA0,  0xA0, 0xA0, 0x00,  0xA0, 0xA0, 0xA0,
0x50, 0x50, 0x50,  0x00, 0x00, 0xF0,  0x00, 0xF0, 0x00,  0x00, 0xF0, 0xF0,
0xF0, 0x00, 0x00,  0xF0, 0x00, 0xF0,  0xF0, 0xF0, 0x00,  0xF0, 0xF0, 0xF0,

/* Gray shades */
0x00, 0x00, 0x00,  0x10, 0x10, 0x10,  0x20, 0x20, 0x20,  0x30, 0x30, 0x30,
0x40, 0x40, 0x40,  0x50, 0x50, 0x50,  0x60, 0x60, 0x60,  0x70, 0x70, 0x70,
0x80, 0x80, 0x80,  0x90, 0x90, 0x90,  0xA0, 0xA0, 0xA0,  0xB0, 0xB0, 0xB0,
0xC0, 0xC0, 0xC0,  0xD0, 0xD0, 0xD0,  0xE0, 0xE0, 0xE0,  0xF0, 0xF0, 0xF0,

/* Black to red */
0x00, 0x00, 0x00,  0x10, 0x00, 0x00,  0x20, 0x00, 0x00,  0x30, 0x00, 0x00,
0x40, 0x00, 0x00,  0x50, 0x00, 0x00,  0x60, 0x00, 0x00,  0x70, 0x00, 0x00,
0x80, 0x00, 0x00,  0x90, 0x00, 0x00,  0xA0, 0x00, 0x00,  0xB0, 0x00, 0x00,
0xC0, 0x00, 0x00,  0xD0, 0x00, 0x00,  0xE0, 0x00, 0x00,  0xF0, 0x00, 0x00,

/* Black to green */
0x00, 0x00, 0x00,  0x00, 0x10, 0x00,  0x00, 0x20, 0x00,  0x00, 0x30, 0x00,
0x00, 0x40, 0x00,  0x00, 0x50, 0x00,  0x00, 0x60, 0x00,  0x00, 0x70, 0x00,
0x00, 0x80, 0x00,  0x00, 0x90, 0x00,  0x00, 0xA0, 0x00,  0x00, 0xB0, 0x00,
0x00, 0xC0, 0x00,  0x00, 0xD0, 0x00,  0x00, 0xE0, 0x00,  0x00, 0xF0, 0x00,

/* Black to blue */
0x00, 0x00, 0x00,  0x00, 0x00, 0x10,  0x00, 0x00, 0x20,  0x00, 0x00, 0x30,
0x00, 0x00, 0x40,  0x00, 0x00, 0x50,  0x00, 0x00, 0x60,  0x00, 0x00, 0x70,
0x00, 0x00, 0x80,  0x00, 0x00, 0x90,  0x00, 0x00, 0xA0,  0x00, 0x00, 0xB0,
0x00, 0x00, 0xC0,  0x00, 0x00, 0xD0,  0x00, 0x00, 0xE0,  0x00, 0x00, 0xF0,

/* Blue to cyan (blue and green) */
0x00, 0x00, 0xF0,  0x00, 0x10, 0xF0,  0x00, 0x20, 0xF0,  0x00, 0x30, 0xF0,
0x00, 0x40, 0xF0,  0x00, 0x50, 0xF0,  0x00, 0x60, 0xF0,  0x00, 0x70, 0xF0,
0x00, 0x80, 0xF0,  0x00, 0x90, 0xF0,  0x00, 0xA0, 0xF0,  0x00, 0xB0, 0xF0,
0x00, 0xC0, 0xF0,  0x00, 0xD0, 0xF0,  0x00, 0xE0, 0xF0,  0x00, 0xF0, 0xF0,

/* Cyan (blue and green) to green */
0x00, 0xF0, 0xF0,  0x00, 0xF0, 0xE0,  0x00, 0xF0, 0xD0,  0x00, 0xF0, 0xC0,
0x00, 0xF0, 0xB0,  0x00, 0xF0, 0xA0,  0x00, 0xF0, 0x90,  0x00, 0xF0, 0x80,
0x00, 0xF0, 0x70,  0x00, 0xF0, 0x60,  0x00, 0xF0, 0x50,  0x00, 0xF0, 0x40,
0x00, 0xF0, 0x30,  0x00, 0xF0, 0x20,  0x00, 0xF0, 0x10,  0x00, 0xF0, 0x00,

/* Green to yellow (red and green) */
0x00, 0xF0, 0x00,  0x10, 0xF0, 0x00,  0x20, 0xF0, 0x00,  0x30, 0xF0, 0x00,
0x40, 0xF0, 0x00,  0x50, 0xF0, 0x00,  0x60, 0xF0, 0x00,  0x70, 0xF0, 0x00,
0x80, 0xF0, 0x00,  0x90, 0xF0, 0x00,  0xA0, 0xF0, 0x00,  0xB0, 0xF0, 0x00,
0xC0, 0xF0, 0x00,  0xD0, 0xF0, 0x00,  0xE0, 0xF0, 0x00,  0xF0, 0xF0, 0x00,

/* Yellow (red and green) to red */
0xF0, 0xF0, 0x00,  0xF0, 0xE0, 0x00,  0xF0, 0xD0, 0x00,  0xF0, 0xC0, 0x00,
0xF0, 0xB0, 0x00,  0xF0, 0xA0, 0x00,  0xF0, 0x90, 0x00,  0xF0, 0x80, 0x00,
0xF0, 0x70, 0x00,  0xF0, 0x60, 0x00,  0xF0, 0x50, 0x00,  0xF0, 0x40, 0x00,
0xF0, 0x30, 0x00,  0xF0, 0x20, 0x00,  0xF0, 0x10, 0x00,  0xF0, 0x00, 0x00,

/* Red to magenta (blue and red) */
0xF0, 0x00, 0x00,  0xF0, 0x00, 0x10,  0xF0, 0x00, 0x20,  0xF0, 0x00, 0x30,
0xF0, 0x00, 0x40,  0xF0, 0x00, 0x50,  0xF0, 0x00, 0x60,  0xF0, 0x00, 0x70,
0xF0, 0x00, 0x80,  0xF0, 0x00, 0x90,  0xF0, 0x00, 0xA0,  0xF0, 0x00, 0xB0,
0xF0, 0x00, 0xC0,  0xF0, 0x00, 0xD0,  0xF0, 0x00, 0xE0,  0xF0, 0x00, 0xF0,

/* Magenta (blue and red) to blue */
0xF0, 0x00, 0xF0,  0xE0, 0x00, 0xF0,  0xD0, 0x00, 0xF0,  0xC0, 0x00, 0xF0,
0xB0, 0x00, 0xF0,  0xA0, 0x00, 0xF0,  0x90, 0x00, 0xF0,  0x80, 0x00, 0xF0,
0x70, 0x00, 0xF0,  0x60, 0x00, 0xF0,  0x50, 0x00, 0xF0,  0x40, 0x00, 0xF0,
0x30, 0x00, 0xF0,  0x20, 0x00, 0xF0,  0x10, 0x00, 0xF0,  0x00, 0x00, 0xF0,

/* Black to magenta (blue and red) */
0x00, 0x00, 0x00,  0x10, 0x00, 0x10,  0x20, 0x00, 0x20,  0x30, 0x00, 0x30,
0x40, 0x00, 0x40,  0x50, 0x00, 0x50,  0x60, 0x00, 0x60,  0x70, 0x00, 0x70,
0x80, 0x00, 0x80,  0x90, 0x00, 0x90,  0xA0, 0x00, 0xA0,  0xB0, 0x00, 0xB0,
0xC0, 0x00, 0xC0,  0xD0, 0x00, 0xD0,  0xE0, 0x00, 0xE0,  0xF0, 0x00, 0xF0,

/* Black to cyan (blue and green) */
0x00, 0x00, 0x00,  0x00, 0x10, 0x10,  0x00, 0x20, 0x20,  0x00, 0x30, 0x30,
0x00, 0x40, 0x40,  0x00, 0x50, 0x50,  0x00, 0x60, 0x60,  0x00, 0x70, 0x70,
0x00, 0x80, 0x80,  0x00, 0x90, 0x90,  0x00, 0xA0, 0xA0,  0x00, 0xB0, 0xB0,
0x00, 0xC0, 0xC0,  0x00, 0xD0, 0xD0,  0x00, 0xE0, 0xE0,  0x00, 0xF0, 0xF0,

/* Red to white */
0xF0, 0x00, 0x00,  0xF0, 0x10, 0x10,  0xF0, 0x20, 0x20,  0xF0, 0x30, 0x30,
0xF0, 0x40, 0x40,  0xF0, 0x50, 0x50,  0xF0, 0x60, 0x60,  0xF0, 0x70, 0x70,
0xF0, 0x80, 0x80,  0xF0, 0x90, 0x90,  0xF0, 0xA0, 0xA0,  0xF0, 0xB0, 0xB0,
0xF0, 0xC0, 0xC0,  0xF0, 0xD0, 0xD0,  0xF0, 0xE0, 0xE0,  0xF0, 0xF0, 0xF0,

/* Green to white */
0x00, 0xF0, 0x00,  0x10, 0xF0, 0x10,  0x20, 0xF0, 0x20,  0x30, 0xF0, 0x30,
0x40, 0xF0, 0x40,  0x50, 0xF0, 0x50,  0x60, 0xF0, 0x60,  0x70, 0xF0, 0x70,
0x80, 0xF0, 0x80,  0x90, 0xF0, 0x90,  0xA0, 0xF0, 0xA0,  0xB0, 0xF0, 0xB0,
0xC0, 0xF0, 0xC0,  0xD0, 0xF0, 0xD0,  0xE0, 0xF0, 0xE0,  0xF0, 0xF0, 0xF0,

/* Blue to white */
0x00, 0x00, 0xF0,  0x10, 0x10, 0xF0,  0x20, 0x20, 0xF0,  0x30, 0x30, 0xF0,
0x40, 0x40, 0xF0,  0x50, 0x50, 0xF0,  0x60, 0x60, 0xF0,  0x70, 0x70, 0xF0,
0x80, 0x80, 0xF0,  0x90, 0x90, 0xF0,  0xA0, 0xA0, 0xF0,  0xB0, 0xB0, 0xF0,
0xC0, 0xC0, 0xF0,  0xD0, 0xD0, 0xF0,  0xE0, 0xE0, 0xF0,  0xF0, 0xF0, 0xF0
};

/*==========================================================================*/

