#ifndef _S3C44B0X_H_
#define _S3C44B0X_H_

#ifndef __ASSEMBLY__
#include <linux/types.h>
#include <asm/io.h>

/* macros defined to easy the operation of system registers */
#define SYSREG_GET(r)			inl(r)
#define SYSREG_SET(r, v)		outl((v), r)
#define SYSREG_AND_SET(r, v)		outl(SYSREG_GET(r) & (v), r)
#define SYSREG_OR_SET(r, v)		outl(SYSREG_GET(r) | (v), r)
#define SYSREG_CLR(r, v)		SYSREG_AND_SET(r, ~(v))

#define SYSREG_GETB(r)			inb(r)
#define SYSREG_SETB(r, v)		outb((v), r)
#define SYSREG_AND_SETB(r, v)		outb(SYSREG_GETB(r) & (v), r)
#define SYSREG_OR_SETB(r, v)		outb(SYSREG_GETB(r) | (v), r)
#define SYSREG_CLRB(r, v)		SYSREG_AND_SETB(r, ~(v))

#define SYSREG_GETW(r)			inw(r)
#define SYSREG_SETW(r, v)		outw((v), r)
#define SYSREG_AND_SETW(r, v)		outw(SYSREG_GETW(r) & (v), r)
#define SYSREG_OR_SETW(r, v)		outw(SYSREG_GETW(r) | (v), r)
#define SYSREG_CLRW(r, v)		SYSREG_AND_SETW(r, ~(v))

#endif

/**
 * register definitions for SAMSUNG S3C44B0X
 *
 * Copyright (C) 2003 Christian Schulte <schulte@sympat.de>
 *
 */
 
/*******************/
/*** CPU WRAPPER ***/
/*******************/

#define S3C44B0X_SYSCFG			0x01c00000
#define S3C44B0X_NCACHBE0		0x01c00004 /* configuration of non-cachable areas */
#define S3C44B0X_NCACHBE1		0x01c00008 /* configuration of non-cachable areas */
#define S3C44B0X_SBUSCON		0x01c40000 /* bus configuration */

/* SYSCFG */
#define S3C44B0X_SYSCFG_DA		0x00000020 /* Data Abort disable */
#define S3C44B0X_SYSCFG_RSE		0x00000010 /* Read Stall Option enable */
#define S3C44B0X_SYSCFG_WE		0x00000008 /* Write Buffer enable */

#define S3C44B0X_SYSCFG_CM_NONE		0x00000000 /* Cache Mode */
#define S3C44B0X_SYSCFG_CM_4K		0x00000002
#define S3C44B0X_SYSCFG_CM_8K		0x00000006

#define S3C44B0X_SYSCFG_SE		0x00000001 /* Stall Option enable */

/* SBUSCON */
#define S3C44B0X_SBUSCON_FIX		0x80000000 /* use the fixed configuration that follows (instead of round-robin) */
#define S3C44B0X_SBUSCON_S_LCD_DMA_1	0x00000000 /* read the bus priority of LCD-DMA */
#define S3C44B0X_SBUSCON_S_LCD_DMA_2	0x00004000
#define S3C44B0X_SBUSCON_S_LCD_DMA_3	0x00008000
#define S3C44B0X_SBUSCON_S_LCD_DMA_4	0x0000c000
#define S3C44B0X_SBUSCON_S_ZDMA_1	0x00000000 /* read the bus priority of Z DMA */
#define S3C44B0X_SBUSCON_S_ZDMA_2	0x00001000
#define S3C44B0X_SBUSCON_S_ZDMA_3	0x00002000
#define S3C44B0X_SBUSCON_S_ZDMA_4	0x00003000
#define S3C44B0X_SBUSCON_S_BDMA_1	0x00000000 /* read the bus priority of B DMA */
#define S3C44B0X_SBUSCON_S_BDMA_2	0x00000400
#define S3C44B0X_SBUSCON_S_BDMA_3	0x00000800
#define S3C44B0X_SBUSCON_S_BDMA_4	0x00000c00
#define S3C44B0X_SBUSCON_S_BREQ_1	0x00000000 /* read the bus priority of external BREAK REQUEST */
#define S3C44B0X_SBUSCON_S_BREQ_2	0x00000100
#define S3C44B0X_SBUSCON_S_BREQ_3	0x00000200
#define S3C44B0X_SBUSCON_S_BREQ_4	0x00000300

#define S3C44B0X_SBUSCON_LCD_DMA_1	0x00000000 /* set the bus priority of LCD-DMA */
#define S3C44B0X_SBUSCON_LCD_DMA_2	0x00000040
#define S3C44B0X_SBUSCON_LCD_DMA_3	0x00000080
#define S3C44B0X_SBUSCON_LCD_DMA_4	0x000000c0
#define S3C44B0X_SBUSCON_ZDMA_1		0x00000000 /* set the bus priority of Z DMA */
#define S3C44B0X_SBUSCON_ZDMA_2		0x00000010
#define S3C44B0X_SBUSCON_ZDMA_3		0x00000020
#define S3C44B0X_SBUSCON_ZDMA_4		0x00000030
#define S3C44B0X_SBUSCON_BDMA_1		0x00000000 /* set the bus priority of B DMA */
#define S3C44B0X_SBUSCON_BDMA_2		0x00000004
#define S3C44B0X_SBUSCON_BDMA_3		0x00000008
#define S3C44B0X_SBUSCON_BDMA_4		0x0000000c
#define S3C44B0X_SBUSCON_BREQ_1		0x00000000 /* set the bus priority of external BREAK REQUEST */
#define S3C44B0X_SBUSCON_BREQ_2		0x00000001
#define S3C44B0X_SBUSCON_BREQ_3		0x00000002
#define S3C44B0X_SBUSCON_BREQ_4		0x00000003

  /*************************/
  /*** MEMORY CONTROLLER ***/
  /*************************/

#define S3C44B0X_BWSCON			0x01c80000 /* Bank size, width and type of memory */
#define S3C44B0X_BANKCON0		0x01c80004 /* timing and page modes */
#define S3C44B0X_BANKCON1		0x01c80008
#define S3C44B0X_BANKCON2		0x01c8000c
#define S3C44B0X_BANKCON3		0x01c80010
#define S3C44B0X_BANKCON4		0x01c80014
#define S3C44B0X_BANKCON5		0x01c80018
#define S3C44B0X_BANKCON6		0x01c8001c
#define S3C44B0X_BANKCON7		0x01c80020
#define S3C44B0X_REFRESH		0x01c80024 /* refresh timing */
#define S3C44B0X_BANKSIZE		0x01c80028 /* bank sizes 2,4,8,16,32 MB */
#define S3C44B0X_MRSRB6			0x01c8002c /* burst settings, CAS latency */
#define S3C44B0X_MRSRB7			0x01c80030

/* BWSCON */
#define S3C44B0X_BWSCON_ST7		0x80000000 /* use UB/LB addressing */
#define S3C44B0X_BWSCON_WS7		0x40000000 /* waitstate enable */
#define S3C44B0X_BWSCON_DW7_8		0x00000000 /* data bus width 8bit */
#define S3C44B0X_BWSCON_DW7_16		0x10000000 /* data bus width 16bit */
#define S3C44B0X_BWSCON_DW7_32		0x20000000 /* data bus width 32bit */

#define S3C44B0X_BWSCON_ST6		0x08000000 /* use UB/LB addressing */
#define S3C44B0X_BWSCON_WS6		0x04000000 /* waitstate enable */
#define S3C44B0X_BWSCON_DW6_8		0x00000000 /* data bus width 8bit */
#define S3C44B0X_BWSCON_DW6_16		0x01000000 /* data bus width 16bit */
#define S3C44B0X_BWSCON_DW6_32		0x02000000 /* data bus width 32bit */

#define S3C44B0X_BWSCON_ST5		0x00800000 /* use UB/LB addressing */
#define S3C44B0X_BWSCON_WS5		0x00400000 /* waitstate enable */
#define S3C44B0X_BWSCON_DW5_8		0x00000000 /* data bus width 8bit */
#define S3C44B0X_BWSCON_DW5_16		0x00100000 /* data bus width 16bit */
#define S3C44B0X_BWSCON_DW5_32		0x00200000 /* data bus width 32bit */

#define S3C44B0X_BWSCON_ST4		0x00080000 /* use UB/LB addressing */
#define S3C44B0X_BWSCON_WS4		0x00040000 /* waitstate enable */
#define S3C44B0X_BWSCON_DW4_8		0x00000000 /* data bus width 8bit */
#define S3C44B0X_BWSCON_DW4_16		0x00010000 /* data bus width 16bit */
#define S3C44B0X_BWSCON_DW4_32		0x00020000 /* data bus width 32bit */

#define S3C44B0X_BWSCON_ST3		0x00008000 /* use UB/LB addressing */
#define S3C44B0X_BWSCON_WS3		0x00004000 /* waitstate enable */
#define S3C44B0X_BWSCON_DW3_8		0x00000000 /* data bus width 8bit */
#define S3C44B0X_BWSCON_DW3_16		0x00001000 /* data bus width 16bit */
#define S3C44B0X_BWSCON_DW3_32		0x00002000 /* data bus width 32bit */

#define S3C44B0X_BWSCON_ST2		0x00000800 /* use UB/LB addressing */
#define S3C44B0X_BWSCON_WS2		0x00000400 /* waitstate enable */
#define S3C44B0X_BWSCON_DW2_8		0x00000000 /* data bus width 8bit */
#define S3C44B0X_BWSCON_DW2_16		0x00000100 /* data bus width 16bit */
#define S3C44B0X_BWSCON_DW2_32		0x00000200 /* data bus width 32bit */

#define S3C44B0X_BWSCON_ST1		0x00000080 /* use UB/LB addressing */
#define S3C44B0X_BWSCON_WS1		0x00000040 /* waitstate enable */
#define S3C44B0X_BWSCON_DW1_8		0x00000000 /* data bus width 8bit */
#define S3C44B0X_BWSCON_DW1_16		0x00000010 /* data bus width 16bit */
#define S3C44B0X_BWSCON_DW1_32		0x00000020 /* data bus width 32bit */

#define S3C44B0X_BWSCON_DW0_8		0x00000000 /* data bus width 8bit */
#define S3C44B0X_BWSCON_DW0_16		0x00000002 /* data bus width 16bit */
#define S3C44B0X_BWSCON_DW0_32		0x00000004 /* data bus width 32bit */

#define S3C44B0X_BWSCON_ENDIAN_BIG	0x00000001 /* read-only, samples the endianess input pin */

/* BANKCON */
#define S3C44B0X_BANKCON_TACS_0		0x00000000 /* time, adress setup to CS (in clocks) */
#define S3C44B0X_BANKCON_TACS_1		0x00002000
#define S3C44B0X_BANKCON_TACS_2		0x00004000
#define S3C44B0X_BANKCON_TACS_4		0x00006000

#define S3C44B0X_BANKCON_TCOS_0		0x00000000 /* time, CS to nOE (in clocks) */
#define S3C44B0X_BANKCON_TCOS_1		0x00000800
#define S3C44B0X_BANKCON_TCOS_2		0x00001000
#define S3C44B0X_BANKCON_TCOS_4		0x00001800

#define S3C44B0X_BANKCON_TACC_1		0x00000000 /* access cycle in clocks (in clocks) */
#define S3C44B0X_BANKCON_TACC_2		0x00000100
#define S3C44B0X_BANKCON_TACC_3		0x00000200
#define S3C44B0X_BANKCON_TACC_4		0x00000300
#define S3C44B0X_BANKCON_TACC_6		0x00000400
#define S3C44B0X_BANKCON_TACC_8		0x00000500
#define S3C44B0X_BANKCON_TACC_10	0x00000600
#define S3C44B0X_BANKCON_TACC_14	0x00000700

#define S3C44B0X_BANKCON_TOCH_0		0x00000000 /* time, CS hold on nOE (in clocks) */
#define S3C44B0X_BANKCON_TOCH_1		0x00000040
#define S3C44B0X_BANKCON_TOCH_2		0x00000080
#define S3C44B0X_BANKCON_TOCH_4		0x000000c0

#define S3C44B0X_BANKCON_TCAH_0		0x00000000 /* address hold on after CS (in clocks) */
#define S3C44B0X_BANKCON_TCAH_1		0x00000010
#define S3C44B0X_BANKCON_TCAH_2		0x00000020
#define S3C44B0X_BANKCON_TCAH_4		0x00000030

#define S3C44B0X_BANKCON_TPAC_2		0x00000000 /* page mode access cycle (in clocks) */
#define S3C44B0X_BANKCON_TPAC_3		0x00000004
#define S3C44B0X_BANKCON_TPAC_4		0x00000008
#define S3C44B0X_BANKCON_TPAC_6		0x0000000c

#define S3C44B0X_BANKCON_PMC_1		0x00000000 /* page mode config (in datawords) */
#define S3C44B0X_BANKCON_PMC_4		0x00000001
#define S3C44B0X_BANKCON_PMC_8		0x00000002
#define S3C44B0X_BANKCON_PMC_16		0x00000003

#define S3C44B0X_BANKCON_MT_SRAM	0x00000000 /* memory type selection */
#define S3C44B0X_BANKCON_MT_DRAM	0x00004000
#define S3C44B0X_BANKCON_MT_EDO		0x00008000
#define S3C44B0X_BANKCON_MT_SDRAM	0x00018000

/* only for FP-DRAM or EDO-DRAM */
#define S3C44B0X_BANKCON_TRCD_1		0x00000000 /* RAS to CAS delay */
#define S3C44B0X_BANKCON_TRCD_2		0x00000010
#define S3C44B0X_BANKCON_TRCD_3		0x00000020
#define S3C44B0X_BANKCON_TRCD_4		0x00000030

#define S3C44B0X_BANKCON_TCAS_1		0x00000000 /* CAS pulse width (in clocks) */
#define S3C44B0X_BANKCON_TCAS_2		0x00000008

#define S3C44B0X_BANKCON_TCP_1		0x00000000 /* CAS precharge (in clocks) */
#define S3C44B0X_BANKCON_TCP_2		0x00000004

#define S3C44B0X_BANKCON_CAN_8		0x00000000 /* column address number (in bits) */
#define S3C44B0X_BANKCON_CAN_9		0x00000001
#define S3C44B0X_BANKCON_CAN_10		0x00000002
#define S3C44B0X_BANKCON_CAN_11		0x00000003

/* only for SDRAM */
#define S3C44B0X_BANKCON_SDRAM_TRCD_2	0x00000000 /* RAS to CAS delay */
#define S3C44B0X_BANKCON_SDRAM_TRCD_3	0x00000004
#define S3C44B0X_BANKCON_SDRAM_TRCD_4	0x00000008

#define S3C44B0X_BANKCON_SCAN_8		0x00000000 /* column address number (in bits) */
#define S3C44B0X_BANKCON_SCAN_9		0x00000001
#define S3C44B0X_BANKCON_SCAN_10	0x00000002


/* REFRESH */
#define S3C44B0X_REFRESH_REFEN		0x00800000
#define S3C44B0X_REFRESH_TREFMD		0x00400000


#define S3C44B0X_REFRESH_TRP_1_5	0x00000000 /* for DRAM */
#define S3C44B0X_REFRESH_TRP_2_5	0x00000000
#define S3C44B0X_REFRESH_TRP_3_5	0x00000000
#define S3C44B0X_REFRESH_TRP_4_5	0x00000000
#define S3C44B0X_REFRESH_TRP_2		0x00000000 /* for SDRAM */
#define S3C44B0X_REFRESH_TRP_3		0x00000000
#define S3C44B0X_REFRESH_TRP_4		0x00000000
#define S3C44B0X_REFRESH_TRP_NONE	0x00000000

#define S3C44B0X_REFRESH_TRC_4		0x00000000 /* SDRAM RC minimum time */
#define S3C44B0X_REFRESH_TRC_5		0x00040000
#define S3C44B0X_REFRESH_TRC_6		0x00080000
#define S3C44B0X_REFRESH_TRC_7		0x000c0000

#define S3C44B0X_REFRESH_TCHR_1		0x00000000 /* CAS Hold Time (DRAM) */
#define S3C44B0X_REFRESH_TCHR_2		0x00010000
#define S3C44B0X_REFRESH_TCHR_3		0x00020000
#define S3C44B0X_REFRESH_TCHR_4		0x00030000

#define S3C44B0X_REFRESH_COUNTER	0x000003FF /* mask for the refresh counter (bit 0-10) */

/* BANKSIZE */
#define S3C44B0X_BANKSIZE_SCLKEN	0x00000010
#define S3C44B0X_BANKSIZE_BK76MAP_2	0x00000004
#define S3C44B0X_BANKSIZE_BK76MAP_4	0x00000005
#define S3C44B0X_BANKSIZE_BK76MAP_8	0x00000006
#define S3C44B0X_BANKSIZE_BK76MAP_16	0x00000007
#define S3C44B0X_BANKSIZE_BK76MAP_32	0x00000000

/* MRSRB */
#define S3C44B0X_MRSRB_WBL		0x00000200
#define S3C44B0X_MRSRB_CL_1		0x00000000
#define S3C44B0X_MRSRB_CL_2		0x00000020
#define S3C44B0X_MRSRB_CL_3		0x00000030
#define S3C44B0X_MRSRB_BT_SEQ		0x00000000
#define S3C44B0X_MRSRB_BT_NONSEQ	0x00000008
#define S3C44B0X_MRSRB_BL_1		0x00000000

  /************/
  /*** UART ***/
  /************/
  
#define S3C44B0X_ULCON0			0x01d00000
#define S3C44B0X_UCON0			0x01d00004
#define S3C44B0X_UFCON0			0x01d00008
#define S3C44B0X_UMCON0			0x01d0000c
#define S3C44B0X_UTRSTAT0		0x01d00010
#define S3C44B0X_UERSTAT0		0x01d00014
#define S3C44B0X_UFSTAT0		0x01d00018
#define S3C44B0X_UMSTAT0		0x01d0001c

#ifdef CONFIG_CPU_BIG_ENDIAN
#define S3C44B0X_UTXH0			0x01d00023
#define S3C44B0X_URXH0			0x01d00027
#else
#define S3C44B0X_UTXH0			0x01d00020
#define S3C44B0X_URXH0			0x01d00024
#endif

#define S3C44B0X_UBRDIV0		0x01d00028

#define S3C44B0X_ULCON1			0x01d04000
#define S3C44B0X_UCON1			0x01d04004
#define S3C44B0X_UFCON1			0x01d04008
#define S3C44B0X_UMCON1			0x01d0400c
#define S3C44B0X_UTRSTAT1		0x01d04010
#define S3C44B0X_UERSTAT1		0x01d04014
#define S3C44B0X_UFSTAT1		0x01d04018
#define S3C44B0X_UMSTAT1		0x01d0401c

#ifdef CONFIG_CPU_BIG_ENDIAN
#define S3C44B0X_UTXH1			0x01d04023
#define S3C44B0X_URXH1			0x01d04027
#else
#define S3C44B0X_UTXH1			0x01d04020
#define S3C44B0X_URXH1			0x01d04024
#endif

#define S3C44B0X_UBRDIV1		0x01d04028

/* ULCON */
#define S3C44B0X_ULCON_IR		0x00000040

#define S3C44B0X_ULCON_PAR_NO		0x00000000
#define S3C44B0X_ULCON_PAR_ODD		0x00000020
#define S3C44B0X_ULCON_PAR_EVEN		0x00000028
#define S3C44B0X_ULCON_PAR_1		0x00000030
#define S3C44B0X_ULCON_PAR_0		0x00000038

#define S3C44B0X_ULCON_STOPB_1		0x00000000
#define S3C44B0X_ULCON_STOPB_2		0x00000004

#define S3C44B0X_ULCON_WORDLN_5		0x00000000
#define S3C44B0X_ULCON_WORDLN_6		0x00000001
#define S3C44B0X_ULCON_WORDLN_7		0x00000002
#define S3C44B0X_ULCON_WORDLN_8		0x00000003

/* UCON */
#define S3C44B0X_UCON_TXINT_LEVEL	0x00000200
#define S3C44B0X_UCON_RXINT_LEVEL	0x00000100
#define S3C44B0X_UCON_TXINT_PULSE	0x00000000
#define S3C44B0X_UCON_RXINT_PULSE	0x00000000
#define S3C44B0X_UCON_RX_TIMEOUT_EN	0x00000080
#define S3C44B0X_UCON_RX_ERR_INT_EN	0x00000040
#define S3C44B0X_UCON_LOOP		0x00000020
#define S3C44B0X_UCON_SEND_BREAK	0x00000010

#define S3C44B0X_UCON_TX_DIS		0x00000000
#define S3C44B0X_UCON_TX_MODE_INT_POLL	0x00000004
#define S3C44B0X_UCON_TX_MODE_BDMA0	0x00000008
#define S3C44B0X_UCON_TX_MODE_BDMA1	0x0000000c

#define S3C44B0X_UCON_RX_DIS		0x00000000
#define S3C44B0X_UCON_RX_MODE_INT_POLL	0x00000001
#define S3C44B0X_UCON_RX_MODE_BDMA0	0x00000002
#define S3C44B0X_UCON_RX_MODE_BDMA1	0x00000003

/* UFCON */
#define S3C44B0X_UFCON_TX_FIFO_0	0x00000000 /* TX FIFO byte size */
#define S3C44B0X_UFCON_TX_FIFO_4	0x00000040
#define S3C44B0X_UFCON_TX_FIFO_8	0x00000080
#define S3C44B0X_UFCON_TX_FIFO_12	0x000000c0

#define S3C44B0X_UFCON_RX_FIFO_4	0x00000000 /* RX FIFO byte size */
#define S3C44B0X_UFCON_RX_FIFO_8	0x00000010
#define S3C44B0X_UFCON_RX_FIFO_12	0x00000020
#define S3C44B0X_UFCON_RX_FIFO_16	0x00000030

#define S3C44B0X_UFCON_TX_FIFO_RST	0x00000004
#define S3C44B0X_UFCON_RX_FIFO_RST	0x00000002
#define S3C44B0X_UFCON_FIFO_EN		0x00000001 /* global FIFO enable */

/* UMCON */
#define S3C44B0X_UMCON_AFC		0x00000010  /* auto flow control */
#define S3C44B0X_UMCON_RQST_SEND	0x00000001  /* request to send 1=L(active RTS) 0=H(inactive RTS) */

/* UTRSTAT */
#define S3C44B0X_UTRSTAT_TSE		0x00000004  /* transmitter shifter empty */
#define S3C44B0X_UTRSTAT_TBE		0x00000002  /* transmitt buffer empty */
#define S3C44B0X_UTRSTAT_RBDR		0x00000001  /* receive buffer data ready */

/* UERSTAT */
#define S3C44B0X_UERSTAT_BREAK_DETECT	0x00000008
#define S3C44B0X_UERSTAT_FRAME_ERROR	0x00000004
#define S3C44B0X_UERSTAT_PARITY_ERROR	0x00000002
#define S3C44B0X_UERSTAT_OVERRUN_ERROR	0x00000001

/* UFSTAT */
#define S3C44B0X_UFSTAT_TX_FIFO_FULL	0x00000200
#define S3C44B0X_UFSTAT_RX_FIFO_FULL	0x00000100
#define S3C44B0X_UFSTAT_TX_FIFO_COUNT	0x000000F0
#define S3C44B0X_UFSTAT_RX_FIFO_COUNT	0x0000000F

  /***********/
  /*** SIO ***/
  /***********/

#define S3C44B0X_SIOCON			0x01d14000
#define S3C44B0X_SIODAT			0x01d14004
#define S3C44B0X_SBRDR			0x01d14008
#define S3C44B0X_ITVCNT			0x01d1400c
#define S3C44B0X_DNCTZ			0x01d14010

  /****************************/
  /*** IIS (Inter IC Sound) ***/
  /****************************/

#define S3C44B0X_IISCON			0x01d18000
#define S3C44B0X_IISMOD			0x01d18004
#define S3C44B0X_IISPSR			0x01d18008
#define S3C44B0X_IISFIFCON		0x01d1800c
#define S3C44B0X_IISFIF			0x01d18010

  /*****************/
  /*** I/O ports ***/
  /*****************/

#define S3C44B0X_PCONA			0x01d20000
#define S3C44B0X_PDATA			0x01d20004
#define S3C44B0X_PCONB			0x01d20008
#define S3C44B0X_PDATB			0x01d2000c

#define S3C44B0X_PCONC			0x01d20010
#define S3C44B0X_PDATC			0x01d20014
#define S3C44B0X_PUPC			0x01d20018
#define S3C44B0X_PCOND			0x01d2001c
#define S3C44B0X_PDATD			0x01d20020
#define S3C44B0X_PUPD			0x01d20024
#define S3C44B0X_PCONE			0x01d20028
#define S3C44B0X_PDATE			0x01d2002c
#define S3C44B0X_PUPE			0x01d20030
#define S3C44B0X_PCONF			0x01d20034
#define S3C44B0X_PDATF			0x01d20038
#define S3C44B0X_PUPF			0x01d2003c
#define S3C44B0X_PCONG			0x01d20040
#define S3C44B0X_PDATG			0x01d20044
#define S3C44B0X_PUPG			0x01d20048
#define S3C44B0X_SPUCR			0x01d2004c

  /***************************/
  /*** external interrupts ***/
  /***************************/

#define S3C44B0X_EXTINT			0x01d20050
#define S3C44B0X_EXTINPND		0x01d20054

  /**********************/
  /*** WATCHDOG TIMER ***/
  /**********************/

#define S3C44B0X_WTCON			0x01d30000
#define S3C44B0X_WTDAT			0x01d30004
#define S3C44B0X_WTCNT			0x01d30008

  /*********************/
  /*** A/D CONVERTER ***/
  /*********************/

#define S3C44B0X_ADCCON			0x01d40000
#define S3C44B0X_ADCPSR			0x01d40004
#define S3C44B0X_ADCDAT			0x01d40008

  /*****************/
  /*** PWM TIMER ***/
  /*****************/

#define S3C44B0X_TCFG0			0x01d50000 /* prescaler configuration */
#define S3C44B0X_TCFG1			0x01d50004 /* MUX-input for PWM and DMA */
#define S3C44B0X_TCON			0x01d50008 /* timer control register (start/stop, PWM-out, auto-reload, dead-zone) */
#define S3C44B0X_TCNTB0 		0x01d5000c /* timer counter "buffer" register (read-write) to update the timer counter */
#define S3C44B0X_TCMPB0			0x01d50010 /* timer compare register */
#define S3C44B0X_TCNTO0			0x01d50014 /* timer counter "observation" register (real counter value, read-only) */
#define S3C44B0X_TCNTB1			0x01d50018
#define S3C44B0X_TCMPB1			0x01d5001c
#define S3C44B0X_TCNTO1			0x01d50020
#define S3C44B0X_TCNTB2			0x01d50024
#define S3C44B0X_TCMPB2			0x01d50028
#define S3C44B0X_TCNTO2			0x01d5002c
#define S3C44B0X_TCNTB3			0x01d50030
#define S3C44B0X_TCMPB3			0x01d50034
#define S3C44B0X_TCNTO3			0x01d50038
#define S3C44B0X_TCNTB4			0x01d5003c
#define S3C44B0X_TCMPB4			0x01d50040
#define S3C44B0X_TCNTO4			0x01d50044
#define S3C44B0X_TCNTB5			0x01d50048
#define S3C44B0X_TCNTO5			0x01d5004c

/* TCON */
#define S3C44B0X_TCON_T5_AUTO		0x04000000 /* automatically reload the timer register (cycle) */
#define S3C44B0X_TCON_T5_MAN_UPDATE	0x02000000 /* manualy update the counter (read from TCNTBn) */
#define S3C44B0X_TCON_T5_START		0x01000000 /* start the timer (normal modus) if bit not set -> no decrement of counter */

#define S3C44B0X_TCON_T4_AUTO		0x00800000
#define S3C44B0X_TCON_T4_OUTPUT		0x00400000 /* enable output to the PWM-pin (controlled by TCMPBn and TCNTBn) */
#define S3C44B0X_TCON_T4_MAN_UPDATE	0x00200000
#define S3C44B0X_TCON_T4_START		0x00100000

#define S3C44B0X_TCON_T3_AUTO		0x00080000
#define S3C44B0X_TCON_T3_OUTPUT		0x00040000
#define S3C44B0X_TCON_T3_MAN_UPDATE	0x00020000
#define S3C44B0X_TCON_T3_START		0x00010000

#define S3C44B0X_TCON_T2_AUTO		0x00008000
#define S3C44B0X_TCON_T2_OUTPUT		0x00004000
#define S3C44B0X_TCON_T2_MAN_UPDATE	0x00002000
#define S3C44B0X_TCON_T2_START		0x00001000

#define S3C44B0X_TCON_T1_AUTO		0x00000800
#define S3C44B0X_TCON_T1_OUTPUT		0x00000400
#define S3C44B0X_TCON_T1_MAN_UPDATE	0x00000200
#define S3C44B0X_TCON_T1_START		0x00000100

#define S3C44B0X_TCON_DEAD_ZONE_EN	0x00000010 /* enable the dead zone for PWM-mode */

#define S3C44B0X_TCON_T0_AUTO		0x00000008
#define S3C44B0X_TCON_T0_OUTPUT		0x00000004
#define S3C44B0X_TCON_T0_MAN_UPDATE	0x00000002
#define S3C44B0X_TCON_T0_START		0x00000001

  /***********/
  /*** IIC ***/
  /***********/

#define S3C44B0X_IICCON			0x01d60000
#define S3C44B0X_IICSTAT		0x01d60004
#define S3C44B0X_IICADD			0x01d60008
#define S3C44B0X_IICDS			0x01d6000c

  /***********/
  /*** RTC ***/
  /***********/

#define S3C44B0X_RTCCON			0x01d70040
#define S3C44B0X_RTCALM			0x01d70050
#define S3C44B0X_ALMSEC			0x01d70054
#define S3C44B0X_ALMMIN			0x01d70058
#define S3C44B0X_ALMHOUR		0x01d7005c
#define S3C44B0X_ALMDAY			0x01d70060
#define S3C44B0X_ALMMON			0x01d70064
#define S3C44B0X_ALMYEAR		0x01d70068
#define S3C44B0X_RTCRST			0x01d7006c
#define S3C44B0X_BCDSEC			0x01d70070
#define S3C44B0X_BCDMIN			0x01d70074
#define S3C44B0X_BCDHOUR		0x01d70078
#define S3C44B0X_BCDDAY			0x01d7007c
#define S3C44B0X_BCDDATE		0x01d70080
#define S3C44B0X_BCDMON			0x01d70084
#define S3C44B0X_BCDYEAR		0x01d70088
#define S3C44B0X_TICINT			0x01d7008c

  /********************************/
  /*** CLOCK & POWER MANAGEMENT ***/
  /********************************/

#define S3C44B0X_PLLCON			0x01d80000
#define S3C44B0X_CLKCON			0x01d80004
#define S3C44B0X_CLKSLOW		0x01d80008
#define S3C44B0X_LOCKTIME		0x01d8000c

#define S3C44B0X_CLKCON_IIS		0x4000
#define S3C44B0X_CLKCON_IIC		0x2000
#define S3C44B0X_CLKCON_ADC		0x1000
#define S3C44B0X_CLKCON_RTC		0x0800
#define S3C44B0X_CLKCON_GPIO		0x0400
#define S3C44B0X_CLKCON_UART1		0x0200
#define S3C44B0X_CLKCON_UART0		0x0100
#define S3C44B0X_CLKCON_BDMA		0x0080
#define S3C44B0X_CLKCON_LCDC		0x0040
#define S3C44B0X_CLKCON_SIO		0x0020
#define S3C44B0X_CLKCON_ZDMA		0x0010
#define S3C44B0X_CLKCON_PWMTIMER	0x0008
#define S3C44B0X_CLKCON_IDLE_BIT	0x0004
#define S3C44B0X_CLKCON_SL_IDLE		0x0002
#define S3C44B0X_CLKCON_STOP_BIT	0x0001

#define S3C44B0X_CLKSLOW_PLL_OFF	0x00000010
#define S3C44B0X_CLKSLOW_SLOW_BIT	0x00000008
#define S3C44B0X_CLKSLOW_VAL_0		0x00000000
#define S3C44B0X_CLKSLOW_VAL_1		0x00000001
#define S3C44B0X_CLKSLOW_VAL_2		0x00000002
#define S3C44B0X_CLKSLOW_VAL_3		0x00000003

  /****************************/
  /*** INTERRUPT CONTROLLER ***/
  /****************************/

#define S3C44B0X_INTCON			0x01e00000
#define S3C44B0X_INTPND			0x01e00004
#define S3C44B0X_INTMOD			0x01e00008
#define S3C44B0X_INTMSK			0x01e0000c
#define S3C44B0X_I_PSLV			0x01e00010
#define S3C44B0X_I_PMST			0x01e00014
#define S3C44B0X_I_CSLV			0x01e00018
#define S3C44B0X_I_CMST			0x01e0001c
#define S3C44B0X_I_ISPR			0x01e00020
#define S3C44B0X_I_ISPC			0x01e00024
#define S3C44B0X_F_ISPR			0x01e00038
#define S3C44B0X_F_ISPC			0x01e0003c

  /***********/
  /*** DMA ***/
  /***********/

#define S3C44B0X_ZDCON0			0x01e80000
#define S3C44B0X_ZDISRC0		0x01e80004
#define S3C44B0X_ZDIDES0		0x01e80008
#define S3C44B0X_ZDICNT0		0x01e8000c
#define S3C44B0X_ZDCSRC0		0x01e80010
#define S3C44B0X_ZDCDES0		0x01e80014
#define S3C44B0X_ZDCCNT0		0x01e80018
#define S3C44B0X_ZDCON1			0x01e80020
#define S3C44B0X_ZDISRC1		0x01e80024
#define S3C44B0X_ZDIDES1		0x01e80028
#define S3C44B0X_ZDICNT1		0x01e8002c
#define S3C44B0X_ZDCSRC1		0x01e80030
#define S3C44B0X_ZDCDES1		0x01e80034
#define S3C44B0X_ZDCCNT1		0x01e80038

#define S3C44B0X_BDCON0			0x01f80000
#define S3C44B0X_BDISRC0		0x01f80004
#define S3C44B0X_BDIDES0		0x01f80008
#define S3C44B0X_BDICNT0		0x01f8000c
#define S3C44B0X_BDCSRC0		0x01f80010
#define S3C44B0X_BDCDES0		0x01f80014
#define S3C44B0X_BDCCNT0		0x01f80018
#define S3C44B0X_BDCON1			0x01f80020
#define S3C44B0X_BDISRC1		0x01f80024
#define S3C44B0X_BDIDES1		0x01f80028
#define S3C44B0X_BDICNT1		0x01f8002c
#define S3C44B0X_BDCSRC1		0x01f80030
#define S3C44B0X_BDCDES1		0x01f80034
#define S3C44B0X_BDCCNT1		0x01f80038

#define S3C44B0X_ZDCON_STE_RDY		0x00000000
#define S3C44B0X_ZDCON_STE_NTC		0x00000040
#define S3C44B0X_ZDCON_STE_TC		0x00000080

#define S3C44B0X_ZDCON_QDS_EN		0x00000000
#define S3C44B0X_ZDCON_QDS_DIS		0x0000000c

#define S3C44B0X_ZDCON_CMD_NONE		0x00000000
#define S3C44B0X_ZDCON_CMD_START	0x00000001
#define S3C44B0X_ZDCON_CMD_PAUSE	0x00000002
#define S3C44B0X_ZDCON_CMD_CANCEL	0x00000003


/*********************
 *   LCD controller  *
 *********************/
#define S3C44B0X_LCD_MEM		0x0c060000

#define S3C44B0X_LCDCON1                0x01f00000
#define S3C44B0X_LCDCON2                0x01f00004
#define S3C44B0X_LCDCON3                0x01f00040
#define S3C44B0X_LCDSADDR1              0x01f00008
#define S3C44B0X_LCDSADDR2              0x01f0000c
#define S3C44B0X_LCDSADDR3              0x01f00010

#define S3C44B0X_REDLUT                 0x01f00014
#define S3C44B0X_GREENLUT               0x01f00018
#define S3C44B0X_BLUELUT                0x01f0001c
#define S3C44B0X_DP1_2                  0x01f00020
#define S3C44B0X_DP4_7                  0x01f00024
#define S3C44B0X_DP3_5                  0x01f00028
#define S3C44B0X_DP2_3                  0x01f0002c
#define S3C44B0X_DP5_7                  0x01f00030
#define S3C44B0X_DP3_4                  0x01f00034
#define S3C44B0X_DP4_5                  0x01f00038
#define S3C44B0X_DP6_7                  0x01f0003c

#define S3C44B0X_DITHMODE               0x01f00044

/* LCDCON1 */
#define S3C44B0X_LCDCON1_WLH_4          0x00000000
#define S3C44B0X_LCDCON1_WLH_8          0x00000400
#define S3C44B0X_LCDCON1_WLH_12         0x00000800
#define S3C44B0X_LCDCON1_WLH_16         0x00000c00

#define S3C44B0X_LCDCON1_WDLY_4         0x00000000
#define S3C44B0X_LCDCON1_WDLY_8         0x00000100
#define S3C44B0X_LCDCON1_WDLY_12        0x00000200
#define S3C44B0X_LCDCON1_WDLY_16        0x00000300

#define S3C44B0X_LCDCON1_MMODE          0x00000080

#define S3C44B0X_LCDCON1_DISMODE_4D     0x00000000
#define S3C44B0X_LCDCON1_DISMODE_4S     0x00000020
#define S3C44B0X_LCDCON1_DISMODE_8S     0x00000040

#define S3C44B0X_LCDCON1_INVCLK         0x00000010
#define S3C44B0X_LCDCON1_INVLINE        0x00000008
#define S3C44B0X_LCDCON1_INVFRAME       0x00000004
#define S3C44B0X_LCDCON1_INVVD          0x00000002
#define S3C44B0X_LCDCON1_ENVID          0x00000001


/* LCDCON3 */
#define S3C44B0X_LCDCON3_SELFREFRESH	0x00000001


/* LCDSADDR1 */
#define S3C44B0X_LCDSADDR1_MONO		0x00000000
#define S3C44B0X_LCDSADDR1_GRAY_4	0x08000000
#define S3C44B0X_LCDSADDR1_GRAY_16	0x10000000
#define S3C44B0X_LCDSADDR1_COLOR	0x18000000

/* LCDSADDR2 */
#define S3C44B0X_LCDSADDR2_BSWP     	0x20000000
#endif /* _S3C44B0X_H_ */
