require "socket"
require "rlang"
require "timeout"
require "my/mystring"
require "net/telnet"

class OurTelnet < Net::Telnet
	OPT_COMM_PORT    =  44.chr # ","    # "\x2C" # RFC1722 COM-PORT-OPTION 
	
		SET_BAUDRATE =           1.chr
		SET_DATASIZE =           2.chr
		SET_PARITY =             3.chr
		SET_STOPSIZE =           4.chr
		SET_CONTROL =            5.chr
			SC_REQUEST_FLOW_CONTROL = 0.chr		# Request Com Port Flow Control Setting (outbound/both)
			SC_NO_FLOW_CONTROL = 1.chr				# Use No Flow Control (outbound/both)
			SC_XON_XOFF_FLOW_CONTROL = 2.chr		# Use XON/XOFF Flow Control (outbound/both)
			SC_HW_FLOW_CONTROL = 3.chr				# Use HARDWARE Flow Control (outbound/both)
=begin
             4           Request BREAK State
             5           Set BREAK State ON
             6           Set BREAK State OFF
             7           Request DTR Signal State
             8           Set DTR Signal State ON
             9           Set DTR Signal State OFF
            10           Request RTS Signal State
            11           Set RTS Signal State ON
            12           Set RTS Signal State OFF
            13           Request Com Port Flow Control Setting (inbound)
            14           Use No Flow Control (inbound)
            15           Use XON/XOFF Flow Control (inbound)
            16           Use HARDWARE Flow Control (inbound)
            17           Use DCD Flow Control (outbound/both)
            18           Use DTR Flow Control (inbound)
            19           Use DSR Flow Control (outbound/both)
            20-127       Available for Future Use
=end

		NOTIFY_LINESTATE =       6.chr
		NOTIFY_MODEMSTATE =      7.chr
		FLOWCONTROL_SUSPEND =    8.chr
		FLOWCONTROL_RESUME =     9.chr
		SET_LINESTATE_MASK =     10.chr
		SET_MODEMSTATE_MASK =    11.chr
		PURGE_DATA =             12.chr
	
	COMM_PORT = "COMM-PORT"
	
	def initialize(comm_port, *args)
		super(*args)
		@comm_port = comm_port
		@rest = ""
		@telnet_option[COMM_PORT] = false
		@sub_negotiations = []
	end

	def write2(data)
		$TRACE.debug 5, "+TDATA: #{data.inspect}"
		self.write(data)
	end

	#
	# 
	# NOTE: this code is copied out of Telnet's preprocess function so we can add in support for RFC1722
	#
	def preprocess(string)
		$TRACE.debug 5, "PPDATA[#{@comm_port}]: #{string.inspect}"
		# combine CR+NULL into CR
		string = string.gsub(/#{CR}#{NULL}/no, CR) if @options["Telnetmode"] && !@options["Binmode"]

		# combine EOL into "\n"
		string = string.gsub(/#{EOL}/no, "\n") unless @options["Binmode"]

		did_iac_iac = false
		new_string = string.gsub(/#{IAC}(
							[#{IAC}#{AO}#{AYT}#{DM}#{IP}#{NOP}]|
							[#{DO}#{DONT}#{WILL}#{WONT}]
							[#{OPT_BINARY}-#{OPT_NEW_ENVIRON}#{OPT_COMM_PORT}#{OPT_EXOPL}]|
							#{SB}([^#{IAC}]*)#{IAC}#{SE}
		)/xno) do
			$TRACE.debug 5, "-TDATA[#{@comm_port}]: #{$1.inspect}"
			if    IAC == $1  # handle escaped IAC characters
				$TRACE.debug 5, "in IAC-IAC case with '$0.x'"
				did_iac_iac = true
				IAC
			elsif AYT == $1  # respond to "IAC AYT" (are you there)
				$TRACE.debug 5, "in AYT (are you there) case with '$0.x'"
				self.write2("nobody here but us pigeons" + EOL)
				''
			elsif DO[0] == $1[0]  # respond to "IAC DO x"
				$TRACE.debug 5, "in do case with '$0.x'"
				if OPT_BINARY[0] == $1[1]
					@telnet_option["BINARY"] = true
					self.write2(IAC + WILL + OPT_BINARY)
				elsif OPT_COMM_PORT[0] == $1[1]
					@telnet_option[COMM_PORT] = true
					self.write2(IAC + WILL + OPT_COMM_PORT)
					self.write2(IAC + SB + OPT_COMM_PORT + SET_CONTROL + SC_HW_FLOW_CONTROL + IAC + SE)
				else
					self.write2(IAC + WONT + $1[1..1])
				end
				''
			elsif DONT[0] == $1[0]  # respond to "IAC DON'T x" with "IAC WON'T x"
				$TRACE.debug 5, "in don't case with '$0.x'"
				self.write2(IAC + WONT + $1[1..1])
				''
			elsif WILL[0] == $1[0]  # respond to "IAC WILL x"
				$TRACE.debug 5, "in will case with '$0.x'"
				if OPT_BINARY[0] == $1[1]
					self.write2(IAC + DO + OPT_BINARY)
				elsif OPT_ECHO[0] == $1[1]
					self.write2(IAC + DO + OPT_ECHO)
				elsif OPT_SGA[0]  == $1[1]
					@telnet_option["SGA"] = true
					self.write2(IAC + DO + OPT_SGA)
				elsif OPT_COMM_PORT[0]  == $1[1]
					@telnet_option[COMM_PORT] = true
					self.write2(IAC + DO + OPT_COMM_PORT)
				else
					self.write2(IAC + DONT + $1[1..1])
				end
				''
			elsif WONT[0] == $1[0]  # respond to "IAC WON'T x"
				$TRACE.debug 5, "in won't case with '$0.x'"
				if OPT_ECHO[0] == $1[1]
					self.write2(IAC + DONT + OPT_ECHO)
				elsif OPT_SGA[0]  == $1[1]
					@telnet_option["SGA"] = false
					self.write2(IAC + DONT + OPT_SGA)
				elsif OPT_COMM_PORT[0]  == $1[1]
					@telnet_option[COMM_PORT] = false
					self.write2(IAC + DONT + OPT_COMM_PORT)
				else
					self.write2(IAC + DONT + $1[1..1])
				end
				''
			elsif SB[0] == $1[0]
				$TRACE.debug 5, "[#{@comm_port}]: got SB with #{$2.inspect}"
				@sub_negotiations.push($2)
				''
			else
				$TRACE.debug 5, "in else case with '$0.x'"
				''
			end
		end

		new_string #, did_iac_iac]
	end # preprocess

	#
	# 
	# NOTE: this code is copied out of Telnet's waitfor function since there was no way to use waitfor
	#
	def read_data
		begin
			data = nil
			if RUBY_VERSION == "1.8.6" then
				c = @sock.readpartial(1024 * 1024)
			else
				c = @sock.sysread(1024 * 1024)
			end
			$TRACE.debug 5, "-RDDATA[#{@comm_port}]: #{c.inspect}"
			if @options["Telnetmode"]

=begin
				c = @rest + c
				@rest = ""
				
$TRACE.debug 5, "-RDDATA: with rest #{c.inspect}"

				if pt = c.index(/#{IAC}/) then
$TRACE.debug 5, "-RDDATA: pt = #{pt}"
					if pt == 0 then
						data = ""
					else
						data = c[0..(pt-1)]
					end
$TRACE.debug 5, "-RDDATA: data before IAC = #{data.inspect}"
					data2 = preprocess(c[pt..-1])
$TRACE.debug 5, "-RDDATA: data returned from preprocess = #{data2.inspect}"
					if /^#{IAC}/.match(data2) then
$TRACE.debug 5, "-RDDATA: save for next time"
						@rest = data2
					else
						data += data2
$TRACE.debug 5, "-RDDATA: all together: #{data.inspect}"
					end
				else
					data = c
				end

				data
=end
				
				c = @rest + c
$TRACE.debug 5, "-RDDATA[#{@comm_port}]: with rest #{c.inspect}"
se_index = c.rindex(/#{IAC}#{SE}/no)
sb_index = c.rindex(/#{IAC}#{SB}/no)
$TRACE.debug 5, "-RDDATA[#{@comm_port}]: se_index = #{se_index}, sb_index = #{sb_index}"

				#done = false
				#while !done
				if Integer(c.rindex(/#{IAC}#{SE}/no)) <
					Integer(c.rindex(/#{IAC}#{SB}/no))
$TRACE.debug 5, "-RDDATA[#{@comm_port}]: Has two sub-negotiations"
					data = preprocess(c[0 ... c.rindex(/#{IAC}#{SB}/no)])
					@rest = c[c.rindex(/#{IAC}#{SB}/no) .. -1]
				elsif pt = c.rindex(/#{IAC}[^#{IAC}#{AO}#{AYT}#{DM}#{IP}#{NOP}#{SE}]?\z/no)
$TRACE.debug 5, "-RDDATA[#{@comm_port}]: Got a non IAC pair pt=#{pt}"
					data = preprocess(c[0 ... pt])
$TRACE.debug 5, "-RDDATA[#{@comm_port}]: Got a non IAC pair data=#{data.inspect}"
					@rest = c[pt .. -1]
$TRACE.debug 5, "-RDDATA[#{@comm_port}]: Got a non IAC pair rest=#{@rest.inspect}"
				else
$TRACE.debug 5, "-RDDATA[#{@comm_port}]: Else case"
					data = preprocess(c)
$TRACE.debug 5, "-RDDATA[#{@comm_port}]: data = #{data.inspect}"
					@rest = ''
					#done = true
				end
				#end
			else
				# Not Telnetmode.
				#
				# We cannot use preprocess() on this data, because that
				# method makes some Telnetmode-specific assumptions.
				data = c
				data.gsub!(/#{EOL}/no, "\n") unless @options["Binmode"]
				@rest = ''
			end

			#if /^#{IAC}/.match(data) then
			#	@rest += 
			return data
		rescue EOFError # End of file reached
			if line == '' then
				line = nil
				yield nil if block_given?
			end
			break
		end
	end
end

class RFC2217Redirector
	COMMAND_PORT_BASE = 7000
	
	DATA_CHUNK_SIZE = 1024		# maximum size of chunk of data to write

	IN_EVENT_HASH = {
		"C" => :cts_high,
		"c" => :cts_low,
		"S" => :dsr_high,
		"s" => :dsr_low,
		"D" => :dcd_high,
		"d" => :dcd_low,
		"R" => :ring_high,
		"r" => :ring_low,
		"B" => :break_detected
	}

	OUT_EVENT_HASH = {
		:dtr_high => "D",
		:dtr_low => "d",
		:rts_high => "R",
		:rts_low => "r",
		:set_uart => "U%d-%d-%s-%d-%s",
		:send_break => "B%d"
	}

	PARITY_HASH = {
		:none => "N",
		:even => "E",
		:odd => "O",
		:mark => "M",
		:space => "S"
	}

	FLOW_CONTROL_HASH = {
		:none => "N",
		:hardware => "H",
		:software => "S"
	}
	
	acts_as_rlangable

	interface :connect, [:pid, :host]
	message :connect, [[:pid, :_any, :host, :_any]]

	interface :disconnect, [:pid]
	message :disconnect, [[:pid, :_any]]

	interface :send_data, [:pid, :data]	
	message :send_data, [[:pid, :_any], [:data, :_any]]

	interface :change_signal, [:pid, :event]
	message :change_signal, [[:pid, :_any], [:event, :_any]]

	interface :set_uart, [:pid, :baud_rate, :data_bits, :parity, :stop_bits]
	message :set_uart, [[:pid, :_any], [:baud_rate, :_any], [:data_bits, :_any], [:parity, :_any], [:stop_bits, :_any], [:flow_control, :_any]]

	interface :send_break, [:pid, :break_length]
	message :send_break, [[:pid, :_any], [:break_length, :_any]]

	interface :clear_transmit_data, [:pid]
	message :clear_transmit_data, [[:pid, :_any]]

	thread_func	:run

	attr_reader :comm_port
	
	def initialize(comm_port)
		@comm_port = comm_port
		@connected_lock = Mutex.new
		@command_data = ""
		@receive_data = ""
		@connected = false
		@in_command_queue = []
		@out_command_queue = []
		@waiting_for_first_ok = true
	end

	def connect(listener, host)
		Thread.current[:trace_thread_id] = @comm_port
		
		@listener = listener
		
		begin
			port_num = COMMAND_PORT_BASE + @comm_port - 1
			$TRACE.debug 5, "[#{@comm_port}]: attempting to connect to '#{host}: #{port_num}'"
			@command_port = OurTelnet.new(@comm_port, "Host" => host, "Port" => port_num, "Binmode" => true )
			#puts "connected to command port"
			$TRACE.debug 5, "[#{@comm_port}]: connection suceeded!'"
			
		rescue Exception => e
			$TRACE.debug 5, "[#{@comm_port}]: connection failed because of '#{e.message}''"
			@listener << {:connected => e.message}
			return
		end
		
		#@connected_lock.try_lock do
			@connected = true
		#end

		# send connected is true when we get the \nOK\n
		#@listener << {:connected => true}
	end

	def disconnect(listener)
		# wait until the command queue has been emptied out before closing the ports
		while !@out_command_queue.empty?
			run
		end
		
		@command_port.close
		
		@command_port = nil
		@connected = false

		listener << {:connected => false}
	end

	def clear_transmit_data(sender)
		@out_command_queue = []
	end

	def send_data(sender, data)
		index = 0
		data = data.gsub(/#{Net::Telnet::IAC}/, "#{Net::Telnet::IAC}#{Net::Telnet::IAC}")
		$TRACE.debug 5, "send[#{@comm_port}]: (#{data.size})='#{data[0..80].x}'"
		while (data.size - index) > DATA_CHUNK_SIZE 
			@out_command_queue << {:data => data[index..(index+DATA_CHUNK_SIZE-1)]}
			index += DATA_CHUNK_SIZE
		end
		@out_command_queue << {:data => data[index..-1]}
	end

	def send_break(sender, break_length)
		$TRACE.debug 0, "send_break[#{@comm_port}]: #{break_length} milliseconds"
		@out_command_queue << {:event => [:send_break, break_length]}
	end
	
	def change_signal(sender, event)
		$TRACE.debug 0, "change_signal[#{@comm_port}]: #{event.inspect}"
		@out_command_queue << {:event => event}
	end

	def set_uart(sender, baud_rate, data_bits, parity, stop_bits, flow_control)
		@out_command_queue << {:event => [:set_uart, baud_rate, data_bits, PARITY_HASH[parity], stop_bits, FLOW_CONTROL_HASH[flow_control]]}
	end
	
	def process_commands
		send_data_message(@receive_data.size)
=begin
		$TRACE.debug 5, "process_commands(begin): @comamnd_data = #{@command_data.x}, queue = #{@in_command_queue.inspect}"
		# while there are complete commands available
		while index = @command_data.index(/\n/)
			$TRACE.debug 9, "process_commands(parse): #{index}"

			command = @command_data[0..(index-1)]
			@command_data = @command_data[index+1..-1]

			$TRACE.debug 9, "process_commands(parse2): #{command.x}, #{@command_data.x}"

			case command.chomp
			when /^D(\d+)$/
				#@num_data_bytes = $1.to_i
				$TRACE.debug 9, "process_commands(parse3): got data command #{$1}"
				@in_command_queue << {:data => $1.to_i}
			when /^E([CcDdSsRrB])$/
				raise "unknown event: #{$1}" unless IN_EVENT_HASH[$1]
				$TRACE.debug 9, "process_commands(parse3): got event command #{IN_EVENT_HASH[$1]}"
				@in_command_queue << {:event=> IN_EVENT_HASH[$1]}
			else
			end
		end

		$TRACE.debug 5, "process_commands(mid): #{@in_command_queue.inspect}"

		num_data_bytes = 0
		commands_processed = 0
		@in_command_queue.each_with_index do |command, index|
			$TRACE.debug 9, "process_commands(mid): each command: command=#{command.inspect}, index=#{index}, processed = #{commands_processed}, num_bytes=#{num_data_bytes}"
			if command[:event] then
				if num_data_bytes > 0
					$TRACE.debug 9, "process_commands(mid): send send #{num_data_bytes} bytes because of event"
					send_data_message(num_data_bytes)
					num_data_bytes = 0
				end
					
				@listener << command
				commands_processed += 1
			else
				if command[:data] + num_data_bytes <= @receive_data.size then
					num_data_bytes += command[:data]
					commands_processed += 1
				else
					if num_data_bytes > 0
						$TRACE.debug 9, "process_commands(mid): send send #{num_data_bytes} bytes because of not enough data"
						send_data_message(num_data_bytes) 
						num_data_bytes = 0
					end
					break
				end
			end
		end

		if num_data_bytes > 0 then
			$TRACE.debug 9, "process_commands(mid): send #{num_data_bytes} bytes because enough data"
			send_data_message(num_data_bytes) 
		end

		@in_command_queue = @in_command_queue[commands_processed..-1]

		$TRACE.debug 5, "process_commands(end): #{@in_command_queue.inspect}"
=end
	end

	def send_data_message(num_data_bytes)
		$TRACE.debug 9, "[#{@comm_port}]: num_data_bytes = #{num_data_bytes}"
		$TRACE.debug 9, "[#{@comm_port}]: receive_data(before) = #{@receive_data.inspect}"
		data_message = {:data => @receive_data[0..(num_data_bytes-1)]}
		@receive_data = @receive_data[num_data_bytes..-1]
		@receive_data = "" unless @receive_data
		if data_message != "" then
			$TRACE.debug 5, "[#{@comm_port}]: data_message = #{data_message.inspect}"
			#$TRACE.debug 9, "receive_data(after) = #{@receive_data.inspect}"
			@listener << data_message
		end
	end
	
	def got_data(data)
		$TRACE.debug 5, "[#{@comm_port}]: got_data: receive_data(before) = #{@receive_data.inspect}, data = #{data.inspect}"
		@receive_data << data
		$TRACE.debug 5, "[#{@comm_port}]: got_data: receive_data(after) = #{@receive_data.inspect}"

		if @waiting_for_first_ok then
			if m = /^\r\nOK\r\n(.*)/m.match(@receive_data)
				$TRACE.debug 5, "CONNECTED[#{@comm_port}]: got first OK"
				@receive_data = m[1]
				@waiting_for_first_ok = false

				# send message to port writer to let them know that we are connected
				@listener << {:connected => true}
			end
		end
		
		process_commands
	end
	
	def run		
		#$TRACE.debug 5, "in run: connected = #{@connected}"
		#@connected_lock.try_lock do
			return unless @connected
		#end
@last_time ||= Time.now
if Time.now - @last_time > 1 then
$TRACE.debug 5, "[#{@comm_port}]: in run" 
	@last_time = Time.now
end
		fds = select([@command_port], @out_command_queue.empty? ? [] : [@command_port], nil, 0.1)
		if fds then
			read_ports = fds[0]
			write_ports = fds[1]
			read_ports.each do |port|
				data = port.read_data
				$TRACE.debug 5, "-DATA[#{@comm_port}]: '#{data.inspect}'"
				got_data(data)
			end

			unless @out_command_queue.empty?
				$TRACE.debug 9, "[#{@comm_port}]: out_command_queue = #{@out_command_queue.inspect}"
				next_out_command = @out_command_queue.first
				if next_out_command.has_key?(:data) then
					$TRACE.debug 3, "+DATA[#{@comm_port}]: size=#{next_out_command[:data].size}, data='#{next_out_command[:data][0..80].x}'"
					@command_port.write(next_out_command[:data])
					$TRACE.debug 3, "+DATA[#{@comm_port}]: after"
					@out_command_queue.shift
				elsif next_out_command.has_key?(:event) && write_ports.include?(@command_port) then
=begin
					event = next_out_command[:event]
					event_str = "E"
					if event.is_a?(Array) then
						event_str += OUT_EVENT_HASH[event[0]] % event[1..-1]
					else
						event_str += OUT_EVENT_HASH[event]
					end
					$TRACE.debug 5, "+CMD: '#{event_str}'"
					@command_port.write("#{event_str}\n")
					@out_command_queue.shift
=end
				end
			end
		end
	end
end



