=begin
Erlang example:
............................................
-module(echo).
-export([go/0, loop/0]).
 
go() ->
	Pid2 = spawn(echo, loop, []),
	Pid2 ! {self(), hello},
	receive 
		{Pid2, Msg} ->
			io:format("P1 ~w~n",[Msg])
	end,
	Pid2 ! stop.

loop() ->
	receive
		{From, Msg} -> 
			From ! {self(), Msg},
			loop();
		stop ->
			true
	end.
............................................

=end

require 'pp'
require "thread"
require "SimpleTrace"

class Hash
  def ===(other)
    return false if other.nil? or other.class != self.class
    check_values = []
    self.each_pair {|k,v| check_values << k if v != :_any}
    return false if (self.keys - check_values) != (other.keys - check_values)
    check_values.each {|k| return false if self[k] != other[k] }
    true
  end
end

class Thread
  def name=(value)
    @name = value
  end
  def name
    @name
  end
  def messages
    @messages
  end
 
  def <<(message)
    @message_queue_mutex = Mutex.new if @message_queue_mutex.nil?
    $TRACE.debug 5, "#{self.inspect}: putting message #{message.inspect}"
    @message_queue_mutex.synchronize {
      @messages = [] if @messages.nil?
      @messages << message
    }
  end

  def message
    @message
  end
  
  def receive
    @message_queue_mutex = Mutex.new if @message_queue_mutex.nil?
    begin
    	@message_queue_mutex.lock   #.synchronize {
      @messages = [] if @messages.nil?
      @message = @messages.shift
	   $TRACE.debug 5, "#{self.inspect}: receive message: #{message.inspect}" if @message
	 ensure
	 	@message_queue_mutex.unlock
    end
  end
end

module Rlangable
	class Pattern
		attr_reader :method
		
		def initialize(method, *args)
			@method = method
			arg = args.shift
			if arg.kind_of?(Array)
				@hash = {}
				@ordered_keys = []
				$TRACE.debug 9, "Pattern#initialize: #{arg.inspect}"
				arg.each do |key, value|
					$TRACE.debug 9, "key = #{key.inspect}, value = #{value.inspect}"
					@hash[key] = value
					@ordered_keys.push(key)
				end
			elsif arg.kind_of?(Hash)
				@hash = arg
				@ordered_keys = nil
			else
				raise ArgumentError.new("only a array or hash can be used")
			end

			raise ArgumentError.new("only one argument allowed") unless args.empty?
		end

		def ===(other)
			ret = (@hash === other)
			$TRACE.debug 9, "ret = #{ret} when comparing #{@hash.inspect} with #{other.inspect}"
			ret
		end
		
		def args(message)
			if @ordered_keys then
				@ordered_keys.map {|key| message[key]}
			else
				[message]
			end
		end

		def to_s
			"[hash: #{@hash.inspect}, ordered_keys: #{@ordered_keys.inspect}"
		end
	end
		
	module InstanceMethods
		def start
			@thread = Thread.new do
				begin
				$TRACE.debug 5, "#{self.class}: at start of thread"
				Thread.current.name = self.class.to_s
				while true
					sleep 0.05
					self.class.thread_funcs.each do |tf|
						self.send(tf)
					end
					
					Thread.current.receive
					if msg = Thread.current.message
						$TRACE.debug 5, "#{self.class}: got message #{msg.inspect}, patterns=#{self.class.patterns.inspect}"
						self.class.patterns.each do |pattern|
							$TRACE.debug 9, "checking message against pattern: #{pattern}"
							if pattern === msg then
								$TRACE.debug 5, "found matching pattern, #{pattern.method} with args= #{pattern.args(msg).inspect}"
								self.send(pattern.method, *(pattern.args(msg)))
								break
							end
							$TRACE.debug 9, "done checking message against pattern: #{pattern}"
						end
					end
				end
				rescue Exception => e
					$TRACE.debug 5, "got exception: #{e.message}"
					$TRACE.debug 5, e.backtrace.join("\n")
				end
			end
		end

		def <<(message)
			$TRACE.debug 5, "sending to #{self.class} message=#{message.inspect}"
			@thread << message
		end

		def method_missing(method, *args)
			$TRACE.debug 5, "method_missing: method=#{method}, args=#{args.inspect}"
			$TRACE.debug 9, "interfaces = #{self.class.interfaces.inspect}"
			if keys = self.class.interfaces[method] then
			
				hash = {}
				keys.each do |key|
					hash[key] = args.shift
				end
				$TRACE.debug 5, "pushing message #{hash.inspect} to #{@thread.name}"
				@thread << hash
			else
				super(method, args)
			end
		end
	end

	module ClassMethods
		def message(method, pattern)
			@patterns ||= []
			@patterns << Pattern.new(method, pattern)
		end

		def interface(method, args)
			@interfaces ||= {}
			@interfaces[method] = args
		end

		def thread_func(method)
			@thread_funcs ||= []
			@thread_funcs.push(method)
		end

		def patterns
			@patterns || []
		end

		def interfaces
			@interfaces || {}
		end

		def thread_funcs
			@thread_funcs || []
		end
	end
end

def acts_as_rlangable
	include Rlangable::InstanceMethods
	extend Rlangable::ClassMethods
end


