require "vrtools/vreasylayout"
require "vr/vrtimer"

class UI < VRForm
	include VREasyLayout
	include VRTimerFeasible

	DEFAULT_FONT = VRLocalScreen.factory.newfont("Arial",14)
	BUTTON_HEIGHT = 25
	PORT_LABEL_HEIGHT = 20
	PAUSE_CAPTION = "pause at cycle end"
	RESUME_CAPTION = "resume from pause"
	
	class Terminal
		def initialize(term, buffer_size_control, cycle_control, failure_control)
			@term = term
			@data_mutex = Mutex.new
			@data_received = ""
			@data_in_control = ""
			@buffer_size = 0
			@buffer_size_control = buffer_size_control
			@cycle_control = cycle_control
			@failure_control = failure_control
			@size_limit = 30000
		end

		def on_data(data)
			@data_mutex.synchronize do
				@data_received << data
			end
		end

		def on_timer
			if @data_received.size > 0 && @buffer_size > @size_limit then
				remove_data_at_start
			end

			add_data_at_end
		end

		def on_status(status_hash)
			if status_hash.has_key?("cycle_num") && status_hash.has_key?("num_cycles") then
				@cycle_control.caption = "#{status_hash['cycle_num']} of #{status_hash['num_cycles']}"
			end
			if status_hash.has_key?("num_failures") then
				@failure_control.caption = "#{status_hash['num_failures']}"
			end
		end
		
		private
		
		def remove_data_at_start
			current_eol = 0
			until current_eol > @size_limit / 3 do  #/
				first_eol = @data_in_control.index(/\r\n/)
				current_eol += (first_eol + 2)
				@data_in_control = @data_in_control[(first_eol + 2)..-1]
			end
			@buffer_size -= current_eol
			@term.setSel(0, current_eol)
			@term.replaceSel("")
		end

		def add_data_at_end
			@term.setSel(@buffer_size, @buffer_size)
			@data_mutex.synchronize do
				@data_received.gsub!(/\n/, "\r\n")
				@data_in_control << @data_received
				@term.replaceSel(@data_received)
				@buffer_size += @data_received.size
				
				#@buffer_size_control.caption = @buffer_size.to_s
				@data_received = ""
			end
		end
	end

	def exinit(runner, terminal_infos)
		@runner = runner
		@test_paused = false
		@test_stopped = false
		@terminal_infos = terminal_infos
		@data_received = ""
		@buffer_size = 0
		@terminals = {}
		@trace_info = {}
		@terminal_infos.each do |name, port| 
			@trace_info[port] = {:debug_level => 5, :enabled => false}
		end
		timerfeasibleinit
		self
	end

	def construct
		@line_num = 1
		buffer_size_control = nil
		cycle_control = nil
		failure_control = nil

		pairs_of_terminal_infos = []
		pair = []
		@terminal_infos.each do |name, port|
			if pair == [] then
				pair = [[name, port]]
			else
				pairs_of_terminal_infos.push(pair + [[name, port]])
				pair = []
			end
		end
		pairs_of_terminal_infos.push(pair) unless pair == []	
		pairs_of_terminal_infos

		vert(:spacing => 5) do
			horz(:spacing => 5) do
				static size(40,25), :caption => "Port #"
				edit_box size(50,25), :name => "port_number_edit_control"
				static size(70,25), :caption => "Debug Level:"
				edit_box size(50,25), :name => "debug_level_edit_control"
				button size(50, 25), :caption => "Enable", :name => "enable_disable_debug_button"
			end
			horz do
				button size(100,BUTTON_HEIGHT,INF,BUTTON_HEIGHT), :caption => PAUSE_CAPTION, :name => "pause_button"
				button size(100,BUTTON_HEIGHT,INF,BUTTON_HEIGHT), :caption => "stop cycle", :name => "stop_cycle_button"
				button size(100,BUTTON_HEIGHT,INF,BUTTON_HEIGHT), :caption => "stop test", :name => "stop_test_button"
			end
			pairs_of_terminal_infos.each do |pair_of_terminal_infos|
				horz do
					pair_of_terminal_infos.each do |term_info|
						vert do
							name, port = term_info
							#button size(200,30,INF,30), :caption => "add a line", :name => "add_line_#{port}_button"
							#button size(200,30,INF,30), :caption => "run timer", :name => "run_timer_#{port}_button"
							horz do
								static size(75,PORT_LABEL_HEIGHT,INF,PORT_LABEL_HEIGHT), :caption => name
								static size(75,PORT_LABEL_HEIGHT,INF,PORT_LABEL_HEIGHT), :caption => "cycle: "
								cycle_control = 
								static size(75,PORT_LABEL_HEIGHT,INF,PORT_LABEL_HEIGHT),	:caption => "", :name => "cycle_#{port}_control"
								static size(75,PORT_LABEL_HEIGHT,INF,PORT_LABEL_HEIGHT), :caption => "failures: "
								failure_control = 
								static size(75,PORT_LABEL_HEIGHT,INF,PORT_LABEL_HEIGHT),	:caption => "", :name => "failures_#{port}_control"
								#static size(150,30,INF,30), :caption => "Buffer Size: "
								#buffer_size_control = static size(100,30,INF,30), :name => "buffer_size_#{port}", :caption => ""
							end
							@terminals[port] = Terminal.new(edit_box(size(100,100,INF,INF), :name => "term", :style => WStyle::ES_MULTILINE | 0x100 | WStyle::ES_AUTOVSCROLL | WStyle::WS_HSCROLL | WStyle::WS_VSCROLL), buffer_size_control, cycle_control, failure_control) #WStyle::ES_NOHIDESEL
						end
					end
				end
			end
		end
    	addTimer 50,"update"

		layout_controls

		@debug_level_edit_control.enabled = false
		@enable_disable_debug_button.enabled = false
	end

	#def add_line_1_button_clicked
	#	@terminals[1].on_data("#{@line_num}: " + ("A" * rand(60)) + "\r\n")
	#	@line_num += 1
	#end

	#def run_timer_1_button_clicked
	#	@terminals[1].on_timer
	#end
	
	def term_changed
	end

	def port_number_edit_control_changed
		#$TRACE.debug 0, "port number edit control changed, has value: '#{@port_number_edit_control.text}'"
		port_num = @port_number_edit_control.text.to_i
		if @terminal_infos.map{|name, port| port}.include?(port_num) then
			@debug_level_edit_control.enabled = true
			@enable_disable_debug_button.enabled = true
			@debug_level_edit_control.text = @trace_info[port_num][:debug_level].to_s
			@enable_disable_debug_button.caption = @trace_info[port_num][:enabled] ? "Disable" : "Enable"
		else
			@debug_level_edit_control.enabled = false
			@enable_disable_debug_button.enabled = false
		end			
	end

	def debug_level_edit_control_changed
		new_level = @debug_level_edit_control.text
		if /^(\d)$/.match(new_level)
			port_num = @port_number_edit_control.text.to_i
			@trace_info[port_num][:debug_level] = new_level.to_i
			update_trace_info(port_num)
		end
	end

	def enable_disable_debug_button_clicked
		port_num = @port_number_edit_control.text.to_i
		@trace_info[port_num][:enabled] = !@trace_info[port_num][:enabled]
		@enable_disable_debug_button.caption = @trace_info[port_num][:enabled] ? "Disable" : "Enable"
		update_trace_info(port_num)
	end

	def update_trace_info(port_num)
		$TRACE.set_thread_level(port_num, @trace_info[port_num][:enabled], @trace_info[port_num][:debug_level])
	end
	def input_data(port, data)
		#$TRACE.debug 0, "data = '#{data.x}'"
		@terminals[port].on_data(data)
	end

	def got_status(port, status_hash)
		@terminals[port].on_status(status_hash)
	end

	def pause_button_clicked
		if @test_paused then
			@runner.resume_test
			@pause_button.caption = PAUSE_CAPTION
		else
			@runner.pause_test
			@pause_button.caption = RESUME_CAPTION
		end
		@test_paused = !@test_paused
	end

	def stop_cycle_button_clicked
		if !@test_paused then
			pause_button_clicked
		end
		@runner.stop_cycle
	end

	def stop_test_button_clicked
		@runner.stop_test
		@stop_test_button.enabled = false
		@stop_cycle_button.enabled = false
	end

	def update_timer
		return if @in_update_timer 
		@in_update_timer = true
		@terminals.each_value do |terminal|
			#if rand(100) < 70 then
			#	terminal.on_data("#{@line_num}: " + ("A" * rand(60)) + "\r\n")
			#	@line_num += 1
			#end
			
			terminal.on_timer
		end
		@in_update_timer = false
	end
end

class VR
	def main_loop(threads)
		VRLocalScreen.messageloop
	end
	def show_window(runner, port_infos)
		VRLocalScreen.newform(nil,nil,UI).exinit(runner, port_infos).create.show
	end
	def output_to_proc(window, port)
		proc{|data| window.input_data(port, data)}
	end

	def status_proc(window, port)
		proc{|status_hash| window.got_status(port, status_hash)}
	end
end


#vr = VR.new
#window = vr.show_window([["Port 1", 1]])
#vr.main_loop(nil)
