require "rserialport"
require "usage"

def clean_voice(sp, voice_data)
	dle_count = 0
	cleaned_voice_data = voice_data.gsub(/#{DLE}./) do |x|
		case x
		when /#{DLE}#{DLE}/
			dle_count += 1
			DLE
		when /#{DLE}s/
			sp.log.puts(:status, "found SILENCE")
			""
		else
			sp.log.puts(:status, "found #{x.x}")
			""
		end
	end
	sp.log.puts(:status, "found #{dle_count} DLE-DLE's")

	cleaned_voice_data
end

#$TRACE.set_level 5
#$TRACE.set_output_filename "trace.txt"

Usage.new("[-t p|r] filename") do |u|
	u.die "no direction specified" unless u.dash_t

	with_port(6) do |sp, options|
		sp.write_and_wait_for	"at+fclass=8;s0=0\r", OK
		sp.write_and_wait_for	"at+vit=60\r", OK				# inactivity timer to 60sec 
		sp.write_and_wait_for	"at+vsm=128,8000\r", OK		# set voice comp
		sp.write_and_wait_for	"at+vsd=127,20\r", OK		# set silence detection
		sp.write_and_wait_for	"at+vgt=25\r", OK
		sp.write_and_wait_for	"at+vls=0\r", OK				# deselect all devices
		
		# wait for a RING
		sp.wait_for					/#{DLE}R/, :timeout => 60

		sp.write_and_wait_for	"at+vls=1\r", OK				# answer the phone
	#	sp.write_and_wait_for	"atvts=[933,0,120]\r", OK	# play a beep

		if u.dash_t == "p" then
			sp.write						"at+vtx\r"

			sp.wait_for					CONNECT
			raw_voice_data = nil
			File.open(u.filename, "rb") { |f| raw_voice_data = f.read}
			voice_data = raw_voice_data.gsub(/#{DLE}/, "#{DLE}#{DLE}") + "#{DLE}#{ETX}"
			sp.write						voice_data, :display_byte_count => true
			sp.wait_for					OK, :timeout => 30
		else
			sp.write						"at+vrx\r"						# record voice
			sp.wait_for					CONNECT

			sent_ending = false
			silence_count = 0
			Thread.new do 
				15.times {|count| sleep 1; sp.log.puts "count = #{count}"}
				sp.write("#{DLE}!")
			end
			sp.wait_for					/[^#{DLE}]#{DLE}#{ETX}/, 
											:timeout => 45,
											:display_byte_count => true,
											:match_also => [ 
												[/#{DLE}s/, 
												proc { |m| 
													sp.log.puts(:status,"SILENCE");
													#silence_count += 1
													#if silence_count > 3 then
													#if !sent_ending then
													#	sp.write("#{DLE}!")
													#	sent_ending = true
													#end
													#end
												}
												]
											]
											
			voice_data = sp.last_match.pre_match
			sp.wait_for					OK, :timeout => 10
		end

		if u.dash_t == "r" then
			File.open(u.filename, "wb") {|f| f.write(clean_voice(sp, voice_data))}
		end

		sp.write_and_wait_for	"at+vit=0\r", OK
		sp.write_and_wait_for	"ath\r",	OK
	end
end

