/*
 * This prog will bring the DTR down and the CD down wait for 
 * a few milli sec and quits..
 * 29-10-2003 Javeed changed reset port values . (invertion was needeed).
 * */
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/select.h>


#include <linux/serial.h>
#include <linux/serial_reg.h>

#define		ISIUPCI_READ_REG      (FIOQSIZE + 1)
#define 	ISIUPCI_WRITE_REG     (FIOQSIZE + 2)

struct exser_read_reg {
	int reg;
	int regvalue;
};

int 
main(int argc, char **argv)
{
	int fd = -1;
	int set_value = -1;
	struct exser_read_reg reg_lvl, reg_sel;
	int port;
	struct timeval tv;

	if(argc != 2 )
	{
		printf("Usage resetport /dev/ttyMXXX\n");
		return 0;
	}	
	/* sanity Check is is a really a /dev/tty ??? */
	if(strncmp(argv[1], "/dev/tty", strlen("/dev/tty") ) != 0)
	{
		printf("Device may not be a valid tty\n");
		printf("Usage resetport /dev/ttyMXXX\n");
		return 0;
	}
	/* need to find out the port from /dev/ttyMxx[a-h] */
	port = argv[1][strlen(argv[1]) -1] -'a' ;
	//printf("port = %d\n", port);
	printf("Opening device %s for reset. ", argv[1]);	
	fd = open(argv[1], O_RDWR);	
	if(fd != -1 )
	{
		printf("Resetting Port ");
		fflush(stdout);

		set_value = TIOCM_DTR;

		if (ioctl(fd, TIOCMBIC, &set_value) != 0)
		{
			printf("Failed to reset the DTR\n");
		}
		else
		{
		  	reg_lvl.reg = 0x90;
		  	reg_sel.reg = 0x93;

			/* set the MPIOSel to 0x00 since we want to drive the pins 
			* as output
			* */
			reg_sel.regvalue = 0;
			if (ioctl(fd, ISIUPCI_WRITE_REG , &reg_sel) != 0)
			{
		  	  printf("Failed to set the MPIO Sel to output\n");
		    }

		    reg_lvl.regvalue = ~(0x01 << port);
		//	printf("Value = %x\n", reg.regvalue);
			
			if (ioctl(fd, ISIUPCI_WRITE_REG , &reg_lvl) != 0)
			{
				printf("Failed to set the MPIO for the port\n");
			}
#ifdef USE_SLEEP
			sleep(3);
#else
			tv.tv_sec = 3; //was 0 ... javeed
			tv.tv_usec =0; //was 500000; javeed /* 500 milli */
			select(0, NULL, NULL, NULL, &tv) ;
#endif
			reg_lvl.regvalue =0xff;
			if (ioctl(fd, ISIUPCI_WRITE_REG , &reg_lvl) != 0)
			{
				printf("Failed to reset the MPIO for the port\n");
			}
		  }	
			printf("Done \n");
	//	}
#if 1
		set_value = TIOCM_DTR;

		if (ioctl(fd, TIOCMBIS, &set_value) != 0)
		{
			printf("Failed to set the DTR\n");
		}
		//sleep(5);
#endif
		close(fd);
	}
	else
	{
		printf("Error Opening device \n");
	}
	return 0;
}
