#include <sys/ioctl.h>
#include <sys/fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "ISIResetModem.h"

unsigned char parameter;

int main(int argc,char **argv)
{
	//char	isi_device[12];
	unsigned int fd,fport;

	//printf("\n\tISI Card - Internal Modem Reset Utility\t\n");
	//printf("\t----------------------------------------\t\n");
	//printf("\nSerial Port device name ( eg: \"/dev/ttyM1a\" )\t:");
	//scanf("%s",isi_device);	

	if(argc != 2)
	{	
		printf("\nISIResetModem  : Invalid number of arguments");
		printf("\n\tUsage  : ISIResetModem <port name> \n\tExample: ISIResetModem /dev/ttyM1a \n\n");
		exit(0);
	}	
		

	//clear the screen
	printf("\033[H\033[J\r\n");

	if(parse_dev_name(argv[1]))
	{
		fport=open(argv[1], O_RDWR);
		if(fport == -1)
		{
			printf("\nERROR : Open Failed on Serial Port %s \n\n",argv[1]);
			exit(0);
		}
		
		
		fd=open("/dev/isictl", O_RDWR);
		if(fd == -1)
		{
			printf("\nERROR : Open Failed on /dev/isictl \n\n");
			close(fport);
			exit(0);
		}
		
		close(fport);

		printf("\n\tReset Modem on port %s is in progress ........\n",argv[1]);
		if(ioctl(fd,MIOCTL_MODEM_RESET,&parameter) != 0)
		{
			printf("\n\t!! Reset Modem on port %s failed.\n\n",argv[1]);
			close(fd);
			exit(0);
		}
		else
		{
			printf("\n\t!! Reset Modem on port %s successfully done.\n\n",argv[1]);
		}
		close(fd);

	}
	else
	{
		printf("\nERROR : Invalid Serial Port device name\n\n");
		exit(0);
	}	
		
	return 0;
}


int parse_dev_name(char *devname)
{
	unsigned char portnum,cardnum;
	parameter=0;

	if(strlen(devname) != PORT_NAME_CHARS)
		return 0;
	/*check for ISI port*/
	if(devname[8] != 'M')
		return 0;
	/*check for card number [1-4] */
	if(devname[9] < 49 || devname[9] > 52)
		return 0;

	/*check for port numbers [a-p]*/
	if(devname[10] < 'a' || devname[10] > 'p')
		return 0;

	cardnum=devname[9]-49;
	portnum=devname[10]-97;	
	
	parameter |= (portnum << 4);
	parameter |= cardnum;

	return 1;
}
