#!/usr/bin/env python

###################
#
#    This sample application uses the gpio dev card connected to accessory port
#    one (/sys/devices/platform/mts-io/ap1 to light up LEDs in a sequence
#
###################

###################
#
# IMPORT
#
###################
import time
import os

# Accessory port path
AP1_PATH = "/sys/devices/platform/mts-io/ap1/"

DOUT0 = "dout0"
DOUT1 = "dout1"
DOUT2 = "dout2"
DOUT3 = "dout3"



# main program
def main():
    print "MAIN\n"
    
    dout0 = AP1_PATH + DOUT0
    dout1 = AP1_PATH + DOUT1
    dout2 = AP1_PATH + DOUT2
    dout3 = AP1_PATH + DOUT3
    
    OUTPUT = [dout0, dout1, dout2, dout3]
    
    count = 0
    while True :
        print "count = %d" % count
        print "opening %s" % OUTPUT[count]
        fd = open(OUTPUT[count], 'r+')
        if "1" == fd.read(1):
            fd.write("0")
        else:
            fd.write("1")
        fd.close()
        count = count + 1
        if count > 3:
            count = 0
        status = open("./status.json", 'w+')
        statusString = '{"pid":' + str(os.getpid()) + ',"AppInfo":"Count = ' + str(count) + '"}'
        status.write(statusString)
        time.sleep(5)

# identify main program
if __name__ == "__main__":
    main()
