# erases NAND, flashes bootstrap and u-boot
# Set the rootPath to the location of the release files.
# Set the releaseDir to the specific directory of this release.

set rootPath "C:\\RomBOOT-FlashAEP500-SAM-BA\\"
set releaseDir "AEP"
set rootFilePath 	"$rootPath$releaseDir"

set bootstrapFile	"$rootFilePath\\mtcdt_5.0.0-AEP_uboot-3.8.12.m2.bin"
set ubootFile		"$rootFilePath\\u-boot-mtcdt-2016.09.01-m2.bin"
set uimageFile		"$rootFilePath\\uImage--4.9.87-r9.2-mtcdt-20190628175402.bin"
set rootfsFile		"$rootFilePath\\aep-image-rs9113-mtcdt-20190628175402.rootfs.jffs2"


## NandFlash Mapping
set ubootAddr		0x00040000
set ubootEnv1Addr	0x000C0000
set ubootEnv2Addr	0x00160000
set uimageAddr		0x00200000
set rootfsAddr		0x01800000

puts "-I- === Initialize the NAND access ==="
NANDFLASH::Init

puts "-I- === Enable PMECC OS Parameters ==="
# 4-bit ECC
NANDFLASH::NandHeaderValue HEADER 0xc0902405

puts "-I- === Erase entire NAND flash==="
NANDFLASH::EraseAll

puts "-I- === Load the bootstrap in the first sector ==="
NANDFLASH::SendBootFilePmeccCmd $bootstrapFile

puts "-I- === Load the u-boot image ==="
send_file {NandFlash} "$ubootFile" $ubootAddr 0

puts "-I- === Loading uImage ==="
send_file {NandFlash} "$uimageFile" $uimageAddr 0

# Need to enable Trimffs before writing rootfs or PMECC errors will
# result.
NANDFLASH::NandSetTrimffs 1

puts "-I- === Loading rootfs ==="
send_file {NandFlash} "$rootfsFile" $rootfsAddr 0

puts "-I- === DONE. ==="
