import sys

sys.path.insert(0, '..')

import os
import argparse

from SKFClient.core.utils.log import log, SetLogLevel
from SKFClient.core.utils.config import Config
from SKFClient.app import App

DEFAULT_GLOBAL_CONFIG_FILE = "../config/settings.json"
DEFAULT_LOCAL_CONFIG_FILE = "../config/settings_local.json"


# DESCRIPTION = \
#    """\
# """.format(version=version)
def conf_file_type(file):
    if not os.path.isfile(file):
        raise argparse.ArgumentTypeError("{0} does not exist".format(file))
    return file


def main():
    try:
        log.info(sys.version)
        log.info("Parse SKF client config")
        process_cmd = False

        parser = argparse.ArgumentParser(prog="skf_client",
                                         description="",
                                         formatter_class=argparse.RawDescriptionHelpFormatter)
        parser.add_argument('-gc', '--config', dest='global_config', default=DEFAULT_GLOBAL_CONFIG_FILE,
                            type=conf_file_type, metavar='FILE',
                            help=argparse.SUPPRESS)
        parser.add_argument('-lc', '--local-config', dest='local_config', default=DEFAULT_LOCAL_CONFIG_FILE,
                            type=conf_file_type)
        args = parser.parse_args()

        config = Config.load(args.global_config, args.local_config)

        SetLogLevel(config.log_level)
        log.info("Create SKF client")
        client = App(config)
        try:
            client.run()
        except Exception as error:
            log.error(error, exc_info=True)
            log.error("Failed")
        finally:
            pass
    except Exception as error:
        log.error(error, exc_info=True)

    finally:
        if not process_cmd:
            log.info("Finish SKF Client")


if __name__ == "__main__":
    main()
