class JobEnum:
    def __init__(self):
        pass

    LORA_TO_AWS = 1
    AWS_TO_LORA = 2
    AWS_SHADOW_DELTA_GET = 3
    AWS_GATEWAY_PING = 4
    POST_STATUS = 5
    BROKER_DOWN = 6


class AppContext:
    def __init__(self, config, local_mqtt, aws_mqtt, http_client):
        self.config = config
        self.local_mqtt = local_mqtt
        self.aws_mqtt = aws_mqtt
        self.http_client = http_client
        self.job = {}
        self.myrina_retry = 0

    def add_job(self, job_name, job):
        self.job[job_name] = job

    def get_job(self, job_name):
        return self.job.get(job_name)

    def get_jobs(self):
        return self.job

    def init_jobs(self):
        for job in list(self.job.values()):
            job.init(self)

    def start_jobs(self):
        for job in list(self.job.values()):
            job.start()

    def stop_jobs(self):
        for job in list(self.job.values()):
            job.stop()
