import json

from SKFClient.core.jobs.base_thread import BaseThread
from SKFClient.core.utils.log import log
import time


class AwsGatewayPingJob(BaseThread):

    def on_timer(self, msg):
        log.debug("on_timer")
        json_message = {
            "productId": self.app_context.config.product_id,
            "deviceId": self.app_context.config.device_id,
            "retries": self.app_context.myrina_retry
        }
        out_message = json.dumps(json_message)
        self.app_context.aws_mqtt.publish(self.app_context.config.aws_mqtt_config.gateway_request_topic, out_message,
                                          qos=0)

    def init(self, app_context):
        BaseThread.init(self, app_context)
        self.set_timeout(3600, 10)  # every 60 minutes first call after 10 sec
