import json

from SKFClient.core.jobs.base_thread import BaseThread
from SKFClient.core.utils.log import log
import time


class PostStatusJob(BaseThread):

    def on_timer(self, msg):
        log.debug("on_timer")
        json_message = {
            "productId": self.app_context.config.product_id,
            "deviceId": self.app_context.config.device_id,
            "retries": self.app_context.myrina_retry
        }
        out_message = json.dumps(json_message)
        self.app_context.http_client.gateway_check(out_message)

    def init(self, app_context):
        BaseThread.init(self, app_context)
        self.set_timeout(86400, 10) # every 12 hours first call after 10 sec


