import ssl
from SKFClient.core.utils.log import log
from SKFClient.core.protocol.mqtt.mqtt_client import MQTTClient


class AWSMQTTClient(MQTTClient):

    def run(self):
        #TODO check is file sert exist
        self.client.tls_set(str(self.config.ca_path), certfile=str(self.config.cert_path),
                            keyfile=str(self.config.key_path), cert_reqs=ssl.CERT_REQUIRED,
                            tls_version=ssl.PROTOCOL_TLSv1_2)
        try:
            self.client.connect(self.config.host, self.config.port, self.config.keep_alive_time)
        except Exception as ex:
            log.error(ex, exc_info=True)
        self.client.loop_start()
