# -*- coding: utf-8 -*-
from SKFClient.core.utils.config_utils import check_str, check_port, check_sec, check_list


class AwsConfig:
    def __init__(self, host, port, client_id, keep_alive_time, key_path, cert_path, ca_path, gateway_request_topic,
                 device_request_topic, device_response_topic, key_request_topic, key_response_topic, get_shadow_topic,
                 on_shadow_get_topic, on_shadow_delta_topic, update_shadow_topic):
        self.host = host
        self.port = port
        self.client_id = client_id
        self.keep_alive_time = keep_alive_time
        self.key_path = key_path
        self.cert_path = cert_path
        self.ca_path = ca_path
        self.gateway_request_topic = gateway_request_topic
        self.device_request_topic = device_request_topic
        self.device_response_topic = device_response_topic
        self.key_request_topic = key_request_topic
        self.key_response_topic = key_response_topic
        self.get_shadow_topic = get_shadow_topic
        self.on_shadow_get_topic = on_shadow_get_topic
        self.on_shadow_delta_topic = on_shadow_delta_topic
        self.update_shadow_topic = update_shadow_topic

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        host = check_str(obj.get("host"))
        port = check_port(obj.get("port"))
        client_id = check_str(obj.get("clientId"))
        keep_alive_time = check_sec(obj.get("keepAliveTime"))
        key_path = check_str(obj.get("keyPath"))
        cert_path = check_str(obj.get("certPath"))
        ca_path = check_str(obj.get("caPath"))
        gateway_request_topic = check_str(obj.get("gatewayRequestTopic"))
        device_request_topic = check_str(obj.get("deviceRequestTopic"))
        device_response_topic = check_str(obj.get("deviceResponseTopic"))
        key_request_topic = check_str(obj.get("keyRequestTopic"))
        key_response_topic = check_str(obj.get("keyResponseTopic"))
        get_shadow_topic = check_str(obj.get("getShadowTopic"))
        on_shadow_get_topic = check_str(obj.get("onShadowGetTopic"))
        on_shadow_delta_topic = check_str(obj.get("onShadowDeltaTopic"))
        update_shadow_topic = check_str(obj.get("updateShadowTopic"))

        return AwsConfig(host, port, client_id, keep_alive_time, key_path, cert_path, ca_path, gateway_request_topic,
                         device_request_topic, device_response_topic, key_request_topic, key_response_topic,
                         get_shadow_topic, on_shadow_get_topic, on_shadow_delta_topic, update_shadow_topic)

    def to_dict(self):
        result = {"host": check_str(self.host), "port": check_port(self.port), "clientId": check_str(self.client_id),
                  "keyPath": check_str(self.key_path), "certPath": check_str(self.cert_path),
                  "caPath": check_port(self.ca_path), "keepAliveTime": check_sec(self.keep_alive_time),
                  "gatewayRequestTopic": check_str(self.gateway_request_topic),
                  "deviceRequestTopic": check_str(self.device_request_topic),
                  "deviceResponseTopic": check_str(self.device_response_topic),
                  "keyRequestTopic": check_str(self.key_request_topic),
                  "keyResponseTopic": check_str(self.key_response_topic),
                  "getShadowTopic": check_str(self.get_shadow_topic),
                  "onShadowGetTopic": check_str(self.on_shadow_get_topic),
                  "onShadowDeltaTopic": check_str(self.on_shadow_delta_topic),
                  "updateShadowTopic": check_str(self.update_shadow_topic)}

        return result
