# -*- coding: utf-8 -*-
from SKFClient.core.utils.config_utils import check_str, check_port, check_sec, check_list


class HttpConfig:
    def __init__(self, host, port, auth_user, auth_password, gateway_check_url,
                 gateway_error_url):
        self.host = host
        self.port = port
        self.auth_user = auth_user
        self.auth_password = auth_password
        self.gateway_check_url = gateway_check_url
        self.gateway_error_url = gateway_error_url

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        host = check_str(obj.get("host"))
        port = check_port(obj.get("port"))
        auth_user = check_str(obj.get("authUser"))
        auth_password = check_str(obj.get("authPassword"))
        gateway_check_url = check_str(obj.get("gatewayCheckURL"))
        gateway_error_url = check_str(obj.get("gatewayErrorURL"))

        return HttpConfig(host, port, auth_user, auth_password, gateway_check_url, gateway_error_url)

    def to_dict(self):
        result = {"host": check_str(self.host),
                  "port": check_port(self.port),
                  "authUser": check_str(self.auth_user),
                  "authPassword": check_str(self.auth_password),
                  "gatewayCheckURL": check_str(self.gateway_check_url),
                  "gatewayErrorURL": check_str(self.gateway_error_url)}

        return result
