import logging
import logging.handlers

log = logging.getLogger('SKFClientLogger')

__sys_handler = logging.handlers.SysLogHandler(address='/dev/log')
__sys_formatter = logging.Formatter('skfc: [%(levelname)s] [%(module)s:%(lineno)d] %(message)s')
__sys_handler.setFormatter(__sys_formatter)

__stream_handler = logging.StreamHandler()
__stream_formatter = logging.Formatter(
    '%(asctime)s [%(levelname)s] [%(module)s:%(lineno)d] %(message)s')
__stream_handler.setFormatter(__stream_formatter)

log.addHandler(__sys_handler)
log.addHandler(__stream_handler)


def SetLogLevel(level):
    log.setLevel(level)

SetLogLevel("INFO")
