# -*- coding: utf-8 -*-
from SKFClient.core.utils.config_utils import check_str, check_port, check_sec, check_list


class MQTTConfig:
    def __init__(self, host, port, client_id, keep_alive_time, lora_uplink_topic,
                 lora_downlink_topic, lora_downlink_clear_topic):
        self.host = host
        self.port = port
        self.keep_alive_time = keep_alive_time
        self.lora_uplink_topic = lora_uplink_topic
        self.lora_downlink_topic = lora_downlink_topic
        self.lora_downlink_clear_topic = lora_downlink_clear_topic
        self.client_id = client_id

    @staticmethod
    def from_dict(obj):
        assert isinstance(obj, dict)
        host = check_str(obj.get("host"))
        port = check_port(obj.get("port"))
        client_id = check_str(obj.get("clientId"))
        keep_alive_time = check_sec(obj.get("keepAliveTime"))
        lora_uplink_topic = check_str(obj.get("loraUplinkTopic"))
        lora_downlink_topic = check_str(obj.get("loraDownlinkTopic"))
        lora_downlink_clear_topic = check_str(obj.get("loraDownlinkClearTopic"))

        return MQTTConfig(host, port, client_id, keep_alive_time, lora_uplink_topic, lora_downlink_topic,
                          lora_downlink_clear_topic)

    def to_dict(self):
        result = {"host": check_str(self.host), "port": check_port(self.port),
                  "clientId": check_str(self.client_id),
                  "keepAliveTime": check_sec(self.keep_alive_time),
                  "loraUplinkTopic": check_str(self.lora_uplink_topic),
                  "loraDownlinkTopic": check_str(self.lora_downlink_topic),
                  "loraDownlinkClearTopic": check_str(self.lora_downlink_clear_topic)}

        return result
