# How to use

This tool is used to generate an application and configuration for MultiTech Conduit (blue box) and MTCAP (white box) gateway that sets it up for working with SKF lubricator control panel.

## Generating new factory config

In the application, click the button "Create new factory config" below the CSV
response field. The application will try to get a config from the API and in
case your account has the appropriate permissions the response will appear in
the CSV response field. In case of failure you can contact Myrina staff.

## Installing via Ethernet cable

It is easier to make the very first installation via Ethernet cable since brand-new devices come
without settings that would allow the gateway to connect to DeviceHQ (i.e. sim APN, DeviceHQ key, etc).

After generating an app (see instructions above) simply click **Install** button wait for installation to finish
(Console window will notify you with green success text).

## Installing via DeviceHQ

Subsequent installations on remote locations can be done via DeviceHQ website.

Note that application installation via DeviceHQ makes sense only **if there is a need to install Node Red AWS packages**.
In case you just want to update configuration (that includes AWS ceritifcates, password change, lorasync.py and Node Red flow) you need to just **schedule configuration upgrade** in DevicqHQ.

### Update config from DeviceHQ

1. If you didn't configure the gateway in your PC the current parameters are
   available at **Device HQ** -> **Find the device Serial** -> **Device files** -> **Download Configuration**
2. Open SKF Gateway Set Up and go to **Tools** -> **Get device data** menu and follow instructions. Browse the current gateway parameters that you downloaded above. The gateway current parameters will be uploaded.
    **To update to a new Certificate:**
    **At SKF Gateway Set Up:**
3. Copy response CSV text and paste it to this tool in "Paste CSV response you got from Swagger API" textbox. Note: if you generated multiple gateways be sure to paste them in here one by one and not altogether.
    Use the gateway password (Contained at folder loginDetails.txt - request it to Multitech - Create a database for the generated GW)
4. Optional: specify sim PIN, sim APN or DeviceHQ key.
5. Click Generate
6. Open folder where the application archive is saved.

### Schedule application install

1. After app was generated log in to [DeviceHQ](https://www.devicehq.com)
2. Go to **Developer** menu
3. Click **+ Upload App** button.
4. Choose application archive:
   under folder where you run this tool from go to "Gateways" folder, then to the folder of your
   gateway e.g. "CT61YF09", there you will find file that ends with "**_setup.tar.gz**", e.g. "CT61YF09_setup.tar.gz"
5. Click **Upload App**.
6. Go to **Devices** menu
7. Choose the device on which you want to install the application.
8. Click **Schedule** -> **Install App** -> Your application
9. Click **Schedule App Install**

You can test following these steps for the gateway CW65LF79 for which you created the Certificate KK66KU12 (XV75YY17) and let me know if you have any issues or doubts.

### Schedule Configuration Upgrade

1. After configuration was generated log in to <a href="https://www.devicehq.com">DeviceHQ</a>
2. Go to **Files** menu
3. Click **New Configuration** button.
4. Choose configuration archive:
   under folder where you run this tool from go to "Gateways" folder, then to the folder of your
   gateway e.g. "CT61YF09", there you will find file that ends with "**_config.tar.gz**", e.g. "CT61YF09_config.tar.gz"
5. Click **Upload**.
6. Go to **Devices** menu
7. Choose the device on which you want to install the application.
8. Click **Schedule** -> **Upgrade Config** -> Your configuration
9. Click **OK**

Scheduled applications are installed next time gateway will connect to DeviceHQ, the default interval is every 12 hours.
If you want to force a gateway to connect to DeviceHQ you can do it in gateway dashboard (accessed locally via Ethernet https://192.168.2.1) by clicking **Check-In To DeviceHQ** under Administration -> Remote Management.
(If you don't see "Connecting" message appearing - try to click it again, it may take couple of tries depending on signal strength and network state)

## Custom configuration

All the generate configuration and gateways exists in the
AppData/GatewaySetupTool folder. Below are listed of files you can use to
configure generation.

### lora\_channel_mapping.json

Json file where you can change how lora channel should be configured for
specific model. Default config will be generated with the first config generation.

## Contact info

Address your technical questions to: MaPro Technical Service [MaPro.Technical.Service@skf.com](mailto:MaPro.Technical.Service@skf.com)


