# vi: ts=8 sw=8
#
# MTS TI USB 3410/5052 Spec File
#
# Copyright (C) 2008 Multi-Tech Systems, based on Texas Instruments 2004
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# For questions or problems with this driver, contact Multi-Tech Systems
# technical support.
# 
# $Id: mts_ti_usb_2.6-1.3.1.spec,v 1.1 2008-11-17 02:23:30 drg Exp $
#

Summary:	Multi-Tech Systems driver for modems based on TI-USB 3410 Linux 2.6 kernel
Name:		mts_ti_usb-2.6
Version:	1.3.1
Release:	1
Copyright:	GPL
Group:		Applications/Communications
Source:		mts_ti_usb-2.6-1.3.1.tar.bz2
Url:		http://www.ti.com
Distribution:	Multi-Tech Systems TI-USB 3410/5052 Linux 2.6 Driver
Vendor:		Multi-Tech Systems
Packager:	Don Greiveldinger <dgreiveldinger at multitech dot com>
ExclusiveOS:	Linux
BuildRoot:	%{_tmppath}/%{name}-%{version}-buildroot


%description
This packages contains the Linux 2.6 driver for the MTS TI-USB 3410 based modems.


%prep
%setup -q


%build
%configure
	make


%install
	rm -rf $RPM_BUILD_ROOT
	make install_rpm TI_USB_BUILDROOT=$RPM_BUILD_ROOT


%clean
	rm -rf $RPM_BUILD_ROOT


%post
	MODULE_DIR=/lib/modules/`uname -r`/misc

	# install ti_usb_3410_5052 module
	install -m 0755 -d $MODULE_DIR
	install -m 0644 /etc/ti_usb/ti_usb_3410_5052.ko $MODULE_DIR

	# install new module
	rmmod ti_usb_3410_5052 > /dev/null 2>&1
	/sbin/depmod -ae
	modprobe ti_usb_3410_5052

	true


%preun
	MODULE_DIR=/lib/modules/`uname -r`/misc

	# remove module
	rm -f $MODULE_DIR/ti_usb_3410_5052.ko
	rmmod ti_usb_3410_5052 > /dev/null 2>&1
	/sbin/depmod -ae

	true

%files

# directories
%dir /etc/ti_usb

# /etc/ti_usb
/etc/ti_usb/mts_ti_usb_2.6_release_notes-1.3.1.txt
/etc/ti_usb/ti_usb_3410_5052.ko
/etc/ti_usb/ti_usb_3410_5052
/etc/ti_usb/ti_usb_3410_5052.hotplug

# hotplug
/etc/hotplug/usb/ti_usb_3410_5052

# documentation
%doc mts_ti_usb_2.6_release_notes-1.3.1.txt
%doc COPYING
