# vi: ts=8 sw=8
#
# MTS TI USB 3410/5052 Spec File
#
# Copyright (C) 2008 Multi-Tech Systems based on Texas Instruments 2004
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# For questions or problems with this driver, contact Multi-Tech Systems
# technical support.
# 
# $Id: mts_ti_usb_2.4-1.3.1.spec,v 1.1 2008-11-17 20:44:26 drg Exp $
#

Summary:	Multi-Tech Systems driver for modems based on TI-USB 3410 Linux 2.4 kernel
Name:		mts_ti_usb-2.4	
Version:	1.3.1
Release:	1
Copyright:	GPL
Group:		Applications/Communications
Source:		mts_ti_usb-2.4-1.3.1.tar.bz2
Url:		http://www.ti.com
Distribution:	Multi-Tech Systems TI-USB 3410/5052 Linux 2.4 Driver
Vendor:		Multi-Tech Systems
Packager:	Don Greiveldinger <Don at Greiveldinger dot com>
ExclusiveOS:	Linux
ExcludeArch:	alpha sparc sparc64 mipseb ppc m68k sgi rs6000
BuildRoot:	%{_tmppath}/%{name}-%{version}-buildroot


%description
This packages contains the Linux driver for the TI USB 3410/5052
USB to serial converter devices.


%prep
%setup -q


%build
%configure
	make


%install
	rm -rf $RPM_BUILD_ROOT
	make install_rpm TI_USB_BUILDROOT=$RPM_BUILD_ROOT


%clean
	rm -rf $RPM_BUILD_ROOT


%post
	MODULE_DIR=/lib/modules/`uname -r`/misc

	# clean up old files
	rm -f $MODULE_DIR/ti_3410_5052.o
	rm -f /etc/hotplug/usb/ti_usb

	# install ti_usb module
	install -m 0755 -d $MODULE_DIR
	install -m 0644 /etc/ti_usb/ti_usb.o $MODULE_DIR

	# modify /etc/modules.conf
	rm -f $MODULES_CONF_TMP
	if ! grep "^post-install ti_usb /etc/ti_usb/make_devices" /etc/modules.conf > /dev/null 2>&1
	then
		echo "post-install ti_usb /etc/ti_usb/make_devices" >> /etc/modules.conf
	fi

	# install new module
	rmmod ti_usb > /dev/null 2>&1
	/sbin/depmod -ae
	/sbin/modprobe ti_usb

	true


%preun
	MODULE_DIR=/lib/modules/`uname -r`/misc
	MODULES_CONF_TMP=/etc/modules.conf.tmp.$$

	# remove devices
	/etc/ti_usb/make_devices remove

	# clean up /etc/modules.conf
	rm -f $MODULES_CONF_TMP
	grep -v "^post-install ti_usb /etc/ti_usb/make_devices" /etc/modules.conf > $MODULES_CONF_TMP
	mv -f $MODULES_CONF_TMP /etc/modules.conf

	# remove module
	rm -f $MODULE_DIR/ti_usb.o
	rmmod ti_usb > /dev/null 2>&1
	/sbin/depmod -ae

	true

%files

# directories
%dir /etc/ti_usb

# /etc/ti_usb
/etc/ti_usb/mts_ti_usb_2.4_release_notes-1.3.1.txt
/etc/ti_usb/make_devices
/etc/ti_usb/ti_usb.o

# documentation
%doc mts_ti_usb_2.4_release_notes-1.3.1.txt
%doc COPYING
