# install.rb
#
# Update from 1.15 => 1.16
#

require '/opt/multiaccess/ruby/version'

$product = "multiaccess"
$curVersion = "1.15"
$newVersion = "1.16"

def repair_issue
 inFileData = IO.readlines( "/etc/issue" )
 
 inFileData[0].gsub!($curVersion, $newVersion)

 outFile = File.open( "/etc/issue", "w" )

 inFileData.each do |line|
   outFile.puts line
 end

 outFile.close 
end

# Edit the pslave files to reduce the amount of debug in the messages file
def convertPortslave
	# Read all the lines
	lines = IO.readlines( "/opt/multiaccess/data/pslaveall" )
	
	# Open the file for writing
	f = File.open("/opt/multiaccess/data/pslaveall", "w" )
	
	# Parse thru the file
	lines.each do |line|
		line.chomp!

		# Look for the debug line
		if /(.*debug\s*)(\d)/.match(line) then
			# Turn off the debug
			f.puts $1 + "0"
		else
			f.puts line
		end
	end
	# Close the file
	f.close

	#Now remove the debug from the ppp sections
	for i in 1..4
		removePPPdebug( "/opt/multiaccess/data/pslave#{i}" )
	end
	
end


def removePPPdebug( filename )
	# Read all the lines
	lines = IO.readlines( filename )

	# Open the file for writing
	f = File.open( filename, "w" )

	# Parse thru the file
	lines.each do |line|
		line.chomp!

		# Look for the word debug
		if /(.*)debug(.*)/.match( line ) then
			# remove debug from the line
			f.puts $1 + $2
		else
			f.puts line
		end
	end

	# Close the file
	f.close
end

#
# Check that current installed version 
#

curVersion = Version.new( "/opt/multiaccess/ruby/versions" )
curVersion.readList
if ( curVersion.getVersion( $product ) != $curVersion ) then
  raise "This update was meant to be applied to #{$product} version #{$curVersion}, not #{curVersion.getVersion( $product )}.\n"
end

#
# Save original files in case of uninstall
#

system( "mkdir originals" )

system( "mkdir originals/driver" )
system( "cp /opt/multiaccess/falc0/nb originals/driver/" )

system( "mkdir originals/etc" )
system( "cp /etc/issue originals/etc/" )

system( "mkdir originals/etc/init.d" )
system( "cp /etc/init.d/boot.local originals/etc/init.d/" )

system( "mkdir originals/htdocs" )
system( "cp /opt/multiaccess/htdocs/fax.php originals/htdocs/" )

#
# Copy new stuff
#
system( "cp etc/init.d/boot.local /etc/init.d/" )
system( "cp htdocs/* /opt/multiaccess/htdocs/" )

# copy the script to install stuff on the reboot
system( "cp multiaccess-1.16-install.rb /opt/multiaccess/once/" )
system( "chmod +x /opt/multiaccess/once/multiaccess-1.16-install.rb" )	

# Copy the fax script to the correct directory
system( "cp /etc/cron.midnight/fax /etc/cron.daily" )

# Reset the values for file check
system( "tune2fs -c0 /dev/hda7" )
system( "tune2fs -c0 /dev/hda1" )
system( "tune2fs -c0 /dev/hda3" )
system( "tune2fs -c0 /dev/hda5" )
system( "tune2fs -c0 /dev/hda6" )

convertPortslave
repair_issue

#
# Update version information
#

curVersion.update( $product, $newVersion )
curVersion.writeList
