# uninstall.rb
#
# Undo update from 1.15 => 1.16
#

require '/opt/multiaccess/ruby/version'

$product = "multiaccess"
$curVersion = "1.16"
$newVersion = "1.15"

# Check that current installed version 
#
curVersion = Version.new( "/opt/multiaccess/ruby/versions" )
curVersion.readList
if curVersion.getVersion( $product ) != $curVersion then
  raise "This uninstall was meant to be applied to #{$product} version #{$curVersion}, not #{curVersion.getVersion( $product )}.\n"
end

#
# Remove updated files
#

system( "rm -f /etc/issue" )

system( "rm -f /etc/init.d/boot.local" )

system( "rm -f /opt/multiaccess/htdocs/fax.php" )

#
# Restore original saved copies from previous install 
#

system( "cp originals/etc/issue /etc/" )
system( "cp originals/etc/init.d/boot.local /etc/init.d" )
system( "cp originals/htdocs/* /opt/multiaccess/htdocs/" )

# remove the update files (also restoring nb and sredirdpool)
system( "cp multiaccess-1.16-remove.rb /opt/multiaccess/once/" )
system( "chmod +x /opt/multiaccess/once/multiaccess-1.16-remove.rb" )	

#
# Update version information
#

curVersion.update( $product, $newVersion )
curVersion.writeList

