@echo off

	REM ---------------------------------------------------------
	REM Batch file used to view a message audit dump generated by
	REM an Omnitel WANTA product.
	REM ---------------------------------------------------------

	REM Usage: RIPAUDIT capture_file_name
	REM (The capture file name extention must be '.CAP').

	REM Example: RIPAUDIT audit

if exist %1.cap goto go
echo "****************
echo "*** %1.CAP DOES NOT EXIST ***"
echo "****************
goto end_end

:go
echo ..Analyzing %1.cap.

	REM Translate the ASCII capture file into a binary file:

xlate -H- %1.cap audit.$$1
if errorlevel 1 goto error

	REM Extract the last sequence after the "**rip_msg_audit*" string:
	REM (the capture could contain more than one audit capture, all appended
	REM one after each other, so analyse the latest one only)

xtract -After **rip_msg_audit* audit.$$1 audit.$$2
if errorlevel 1 goto error

:loop
	move audit.$$2 audit.$$1 >nul
	xtract -After **rip_msg_audit* audit.$$1 audit.$$2 >nul
	if errorlevel 1 goto next
	goto loop

:next

	REM extract only the part before the "**rip_end*" string:

xtract -Before **rip_end* audit.$$1 audit.$$2
if errorlevel 1 goto error

	REM Sort the audit by time-stamp:
	REM (the '????' sequence indicates the oldest audit entry)

xtract -Before  ???? audit.$$2 audit.$$B
if errorlevel 1 goto error
xtract -AKafter_keep ???? audit.$$2 audit.$$A
if errorlevel 1 goto error
copy /b audit.$$A+audit.$$B audit.$$3 >NUL

	REM Translate the binary file into a DUMPVIEW-format:

xlate -BIN audit.$$3 audit.$$4 2 64
if errorlevel 1 goto error

	REM View the binary file:

dumpview audit.$$4 -M -T25 >%1.aud
if errorlevel 1 goto error

echo ..%1.aud created.

	REM That's all folks!

goto end

:error
echo "****************
echo "*** ERROR DURING ANALYSIS OF %1.CAP ***"
echo "****************

:end
	REM Delete all temporary files:

del audit.$$?

:end_end
