#ifndef __ETHMON_H__
#define __ETHMON_H__

/* ===[ $RCSfile: ethmon.h,v $ ]==========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: ethmon.h,v 1.1 2005/03/22 20:29:27 cmayncvs Exp $"
 *
 *  \brief Contains the ETHMON API .
 */
/* ======================================================================= */

extern u_int8_t ethmon_dbg_level;

/* ======= */
/* Defines */
/* ======= */

/** The ethmon module's debug level variable name */
#define MODULE_DEBUG_LEVEL  ethmon_dbg_level
/** The ethmon's module name */
#define MODULE_NAME         "EMON"
/** The ethmon timer ID */
#define ETHMON_TMR_ID       0x45544831  /* ASCII for "ETH1" */

#include "debug.h"

void ethmon_process_timeout(void);
void ethmon_dbg_set_level(u_int8_t level);

#endif /* __ETHMON_H__ */


/*
 * End of "$Id: ethmon.h,v 1.1 2005/03/22 20:29:27 cmayncvs Exp $".
 */


