#ifndef __ETHMON_IMP_H__
#define __ETHMON_IMP_H__

/* ===[ $RCSfile: ethmon_imp.h,v $ ]======================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: ethmon_imp.h,v 1.1 2005/03/22 20:29:27 cmayncvs Exp $"
 *
 *  \brief Contains the ETHMON Inter-Module Protocol (IMP) API .
 */
/* ======================================================================= */

/** \brief Indicates that L2 is down */
#define ETHMON_IMP_DOWN         0
/** \brief Indicates that L2 is up */
#define ETHMON_IMP_ONLINE       2

void ethmon_imp_init(const char *local_q, const char *upper_q);
void ethmon_imp_send_status(u_int8_t status);

#endif /* __ETHMON_IMP_H__ */


/*
 * End of "$Id: ethmon_imp.h,v 1.1 2005/03/22 20:29:27 cmayncvs Exp $".
 */


